/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.OpenLRProcessingException;
import openlr.decoder.data.CandidateLine;
import openlr.decoder.data.CandidateLinePair;
import openlr.decoder.data.CandidateLinesResultSet;
import openlr.decoder.properties.OpenLRDecoderProperties;
import openlr.decoder.routesearch.RouteSearch;
import org.apache.log4j.Logger;

public final class DecoderUtils {
    private static final Logger LOG = Logger.getLogger(DecoderUtils.class);

    private DecoderUtils() {
        throw new UnsupportedOperationException();
    }

    public static List<CandidateLinePair> resolveCandidatesOrder(LocationReferencePoint p1, LocationReferencePoint p2, CandidateLinesResultSet candidateLines, CandidateLine lastUsed, OpenLRDecoderProperties properties, LocationType locType) throws OpenLRProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("resolve candidates order with SameLineDegradation: " + properties.getSameLineDegradation() + " and ConnectedRouteIncrease: " + properties.getConnectedRouteIncrease() + " and MaxNrRetries: " + properties.getMaxNumberRetries()));
        }
        ArrayList<CandidateLinePair> pairs = new ArrayList<CandidateLinePair>();
        List<CandidateLine> p1List = candidateLines.getCandidateLines(p1);
        List<CandidateLine> p2List = candidateLines.getCandidateLines(p2);
        for (int i = 0; i < p1List.size(); ++i) {
            int p1Score = p1List.get(i).getRating();
            CandidateLine cl = p1List.get(i);
            if (lastUsed != null && cl.hasSameLine(lastUsed)) {
                p1Score = (int)((float)p1Score + properties.getConnectedRouteIncrease() * (float)p1Score);
            }
            for (int j = 0; j < p2List.size(); ++j) {
                int p2Score = p2List.get(j).getRating();
                if (!p2.isLastLRP() && locType == LocationType.LINE_LOCATION && p2List.get(j).hasSameLine(p1List.get(i))) {
                    p2Score = (int)((float)p2Score - properties.getSameLineDegradation() * (float)p2Score);
                }
                CandidateLinePair candidate = new CandidateLinePair(i, j, p1Score * p2Score);
                pairs.add(candidate);
            }
        }
        Collections.sort(pairs, new CandidateLinePair.CandidateLinePairComparator());
        int returnSize = Math.min(properties.getMaxNumberRetries() + 1, pairs.size());
        List<CandidateLinePair> subList = pairs.subList(0, returnSize);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Candidate pair list for " + p1.getSequenceNumber() + " and " + p2.getSequenceNumber()));
            for (CandidateLinePair clp : subList) {
                LOG.debug((Object)("startIdx[" + clp.getStartIndex() + "] - destIdx[" + clp.getDestIndex() + "], score: " + clp.getScore()));
            }
        }
        return subList;
    }

    public static int determineRouteLength(RouteSearch rs, CandidateLine destCandidate) {
        int length = rs.getRouteLength();
        if (destCandidate.hasProjectionAlongLine()) {
            length += destCandidate.getProjectionAlongLine();
        }
        return length;
    }

    public static int calculateMaxLength(LocationReferencePoint p, CandidateLine candP, CandidateLine candNext, OpenLRDecoderProperties properties) throws OpenLRProcessingException {
        int maxDistance = DecoderUtils.getMaxDistanceNP(p, properties);
        if (candP.hasProjectionAlongLine()) {
            maxDistance += candP.getLine().getLineLength();
        }
        if (candNext.hasProjectionAlongLine()) {
            maxDistance += candNext.getLine().getLineLength();
        }
        return maxDistance;
    }

    public static int getMaxDistanceNP(LocationReferencePoint lrp, OpenLRDecoderProperties properties) throws OpenLRProcessingException {
        return lrp.getDistanceToNext() + properties.getDnpVariance();
    }

    public static int getMinDistanceNP(LocationReferencePoint lrp, OpenLRDecoderProperties properties) throws OpenLRProcessingException {
        return Math.max(0, lrp.getDistanceToNext() - properties.getDnpVariance());
    }
}

