/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker;

import openlr.decoder.OpenLRDecoderProcessingException;
import openlr.decoder.properties.OpenLRDecoderProperties;
import openlr.decoder.worker.AbstractDecoder;
import openlr.location.Location;
import openlr.location.LocationFactory;
import openlr.map.GeoCoordinates;
import openlr.map.InvalidMapDataException;
import openlr.map.MapDatabase;
import openlr.rawLocRef.RawLocationReference;

public class GeoCoordDecoder
extends AbstractDecoder {
    @Override
    public final Location doDecoding(OpenLRDecoderProperties prop, MapDatabase mdb, RawLocationReference rawLocRef) throws OpenLRDecoderProcessingException {
        GeoCoordinates coord = rawLocRef.getGeoCoordinates();
        Location l = null;
        try {
            l = LocationFactory.createGeoCoordinateLocation((String)rawLocRef.getID(), (double)coord.getLongitudeDeg(), (double)coord.getLatitudeDeg());
        }
        catch (InvalidMapDataException e) {
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.INVALID_MAP_DATA, e);
        }
        return l;
    }
}

