/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker;

import openlr.OpenLRProcessingException;
import openlr.decoder.OpenLRDecoderProcessingException;
import openlr.decoder.location.AffectedLinesImpl;
import openlr.decoder.location.DecodedGridLocation;
import openlr.decoder.properties.OpenLRDecoderProperties;
import openlr.decoder.worker.AbstractDecoder;
import openlr.decoder.worker.coverage.GridCoverage;
import openlr.location.Location;
import openlr.location.data.AffectedLines;
import openlr.map.GeoCoordinates;
import openlr.map.InvalidMapDataException;
import openlr.map.MapDatabase;
import openlr.rawLocRef.RawLocationReference;

public class GridDecoder
extends AbstractDecoder {
    @Override
    public final Location doDecoding(OpenLRDecoderProperties prop, MapDatabase mdb, RawLocationReference rawLocRef) throws OpenLRProcessingException {
        DecodedGridLocation decoded = null;
        try {
            GeoCoordinates lowerleft = rawLocRef.getLowerLeftPoint();
            GeoCoordinates upperRight = rawLocRef.getUpperRightPoint();
            int ncols = rawLocRef.getNumberOfColumns();
            int nrows = rawLocRef.getNumberOfRows();
            AffectedLines result = null;
            if (prop.isCalcAffectedLines()) {
                GridCoverage coverage = new GridCoverage(lowerleft, upperRight, ncols, nrows);
                result = coverage.getAffectedLines(mdb);
            } else {
                result = AffectedLinesImpl.EMPTY;
            }
            decoded = new DecodedGridLocation(rawLocRef.getID(), result, ncols, nrows, lowerleft, upperRight);
        }
        catch (InvalidMapDataException e) {
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.INVALID_MAP_DATA, e);
        }
        return decoded;
    }
}

