/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker;

import java.util.ArrayList;
import java.util.List;
import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.Offsets;
import openlr.OpenLRProcessingException;
import openlr.StatusCode;
import openlr.decoder.DecoderReturnCode;
import openlr.decoder.OpenLRDecoderProcessingException;
import openlr.decoder.data.CandidateLine;
import openlr.decoder.data.CandidateLinesResultSet;
import openlr.decoder.data.CandidateNodesResultSet;
import openlr.decoder.data.ResolvedRoutes;
import openlr.decoder.location.DecodedLineLocation;
import openlr.decoder.properties.OpenLRDecoderProperties;
import openlr.decoder.worker.AbstractDecoder;
import openlr.location.InvalidLocation;
import openlr.location.Location;
import openlr.map.Line;
import openlr.map.MapDatabase;
import openlr.map.utils.PathUtils;
import openlr.rawLocRef.RawLocationReference;
import org.apache.log4j.Logger;

public class LineDecoder
extends AbstractDecoder {
    private static final Logger LOG = Logger.getLogger(LineDecoder.class);

    @Override
    public final Location doDecoding(OpenLRDecoderProperties prop, MapDatabase mdb, RawLocationReference rawLocRef) throws OpenLRProcessingException {
        ResolvedRoutes resolvedRoutes;
        CandidateLinesResultSet candidateLines;
        if (mdb == null) {
            return new InvalidLocation(rawLocRef.getID(), (StatusCode)DecoderReturnCode.NO_MAP_DATABASE_FOUND, LocationType.LINE_LOCATION);
        }
        List lrps = rawLocRef.getLocationReferencePoints();
        Offsets od = rawLocRef.getOffsets();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"find candidate nodes");
        }
        CandidateNodesResultSet candidateNodes = this.findCandidateNodes(prop, rawLocRef, mdb);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"find candidate lines");
        }
        if (!(candidateLines = this.findCandidateLines(prop, rawLocRef, candidateNodes, mdb)).allCandidateLinesFound()) {
            return new InvalidLocation(rawLocRef.getID(), (StatusCode)DecoderReturnCode.NO_CANDIDATE_LINE_FOUND, LocationType.LINE_LOCATION);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"resolve routes");
        }
        if (!(resolvedRoutes = this.resolveRoute(prop, rawLocRef, candidateLines, LocationType.LINE_LOCATION)).allRoutesResolved()) {
            ArrayList<List<Line>> subRouteList = new ArrayList<List<Line>>();
            for (LocationReferencePoint p : lrps) {
                List<Line> path = resolvedRoutes.getRoute(p);
                subRouteList.add(path);
            }
            return new InvalidLocation(rawLocRef.getID(), resolvedRoutes.getErrorCode(), LocationType.LINE_LOCATION, subRouteList);
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        ArrayList<List<Line>> subRoutes = new ArrayList<List<Line>>();
        for (LocationReferencePoint p : lrps) {
            List<Line> path = resolvedRoutes.getRoute(p);
            lines.addAll(path);
            subRoutes.add(path);
        }
        if (!PathUtils.checkPathConnection(lines)) {
            LOG.error((Object)"resolved path is not connected");
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.ROUTE_DISCONNECTED);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"prune location path");
        }
        int[] result = this.calculateOffsets(lrps, od, resolvedRoutes);
        Location decoded = this.pruneAndCreateLocation(rawLocRef.getID(), lines, subRoutes, result[0], result[1]);
        return decoded;
    }

    private int[] calculateOffsets(List<? extends LocationReferencePoint> lrps, Offsets od, ResolvedRoutes resolvedRoutes) throws OpenLRDecoderProcessingException {
        LocationReferencePoint lrp1 = lrps.get(0);
        CandidateLine headStartLine = resolvedRoutes.getCandidateStart(lrp1);
        CandidateLine headEndLine = resolvedRoutes.getCandidateEnd(lrp1);
        LocationReferencePoint lrpTail = lrps.get(lrps.size() - 2);
        CandidateLine tailStartLine = resolvedRoutes.getCandidateStart(lrpTail);
        CandidateLine tailEndLine = resolvedRoutes.getCandidateEnd(lrpTail);
        List<Line> routeHead = resolvedRoutes.getRoute(lrp1);
        List<Line> routeTail = resolvedRoutes.getRoute(lrpTail);
        int locationHeadLength = PathUtils.getLength(routeHead);
        int locationTailLength = PathUtils.getLength(routeTail);
        int cutStart = 0;
        int cutEnd = 0;
        if (headStartLine.hasProjectionAlongLine()) {
            cutStart = headStartLine.getProjectionAlongLine();
            locationHeadLength -= cutStart;
        }
        if (tailEndLine.hasProjectionAlongLine()) {
            cutEnd = tailEndLine.getLine().getLineLength() - tailEndLine.getProjectionAlongLine();
            locationTailLength -= cutEnd;
        }
        if (lrp1.getSequenceNumber() == lrpTail.getSequenceNumber()) {
            locationHeadLength -= cutEnd;
            locationTailLength -= cutStart;
        } else {
            if (headEndLine.hasProjectionAlongLine()) {
                locationHeadLength += headEndLine.getProjectionAlongLine();
            }
            if (tailStartLine.hasProjectionAlongLine()) {
                locationTailLength -= tailStartLine.getProjectionAlongLine();
            }
        }
        int startOffset = od.getPositiveOffset(locationHeadLength) + cutStart;
        int endOffset = od.getNegativeOffset(locationTailLength) + cutEnd;
        return new int[]{startOffset, endOffset};
    }

    private Location pruneAndCreateLocation(String id, List<Line> location, List<List<Line>> subRoutes, int posOff, int negOff) throws OpenLRDecoderProcessingException {
        int length;
        Line next;
        ArrayList<Line> pruned = new ArrayList<Line>(location.size());
        pruned.addAll(location);
        int locLength = PathUtils.getLength(pruned);
        if (posOff + negOff >= 2 * locLength) {
            return new InvalidLocation(id, (StatusCode)DecoderReturnCode.INVALID_OFFSETS, LocationType.LINE_LOCATION);
        }
        int pOff = posOff;
        int nOff = negOff;
        int offSum = pOff + nOff;
        if (locLength < offSum) {
            float ratio;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"offsets exceed location length");
            }
            if ((pOff = Math.round((float)posOff * (ratio = (float)locLength / (float)offSum))) > (nOff = Math.round((float)negOff * ratio))) {
                --pOff;
            } else {
                --nOff;
            }
        }
        int prunedLength = 0;
        int remainingPosOff = 0;
        int remainingNegOff = 0;
        if (pOff > 0) {
            while (true) {
                if (pruned.size() == 1) {
                    remainingPosOff = pOff - prunedLength;
                    break;
                }
                next = (Line)pruned.get(0);
                length = next.getLineLength();
                if (prunedLength + length > pOff) {
                    remainingPosOff = pOff - prunedLength;
                    break;
                }
                prunedLength += length;
                pruned.remove(0);
            }
        }
        prunedLength = 0;
        if (nOff > 0) {
            while (true) {
                if (pruned.size() == 1) {
                    remainingNegOff = nOff - prunedLength;
                    break;
                }
                next = (Line)pruned.get(pruned.size() - 1);
                length = next.getLineLength();
                if (prunedLength + length > nOff) {
                    remainingNegOff = nOff - prunedLength;
                    break;
                }
                prunedLength += length;
                pruned.remove(pruned.size() - 1);
            }
        }
        DecodedLineLocation decoded = null;
        decoded = remainingNegOff == 0 && remainingPosOff == 0 ? new DecodedLineLocation(id, pruned, subRoutes) : new DecodedLineLocation(id, pruned, subRoutes, remainingPosOff, remainingNegOff);
        return decoded;
    }
}

