/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker;

import java.util.ArrayList;
import java.util.List;
import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.Offsets;
import openlr.OpenLRProcessingException;
import openlr.StatusCode;
import openlr.decoder.DecoderReturnCode;
import openlr.decoder.OpenLRDecoderProcessingException;
import openlr.decoder.data.CandidateLine;
import openlr.decoder.data.CandidateLinesResultSet;
import openlr.decoder.data.CandidateNodesResultSet;
import openlr.decoder.data.ResolvedRoutes;
import openlr.decoder.location.DecodedPoiAccessLocation;
import openlr.decoder.properties.OpenLRDecoderProperties;
import openlr.decoder.worker.AbstractDecoder;
import openlr.location.InvalidLocation;
import openlr.location.Location;
import openlr.map.InvalidMapDataException;
import openlr.map.Line;
import openlr.map.MapDatabase;
import openlr.map.utils.PathUtils;
import openlr.rawLocRef.RawLocationReference;
import org.apache.log4j.Logger;

public class PoiAccessDecoder
extends AbstractDecoder {
    private static final Logger LOG = Logger.getLogger(PoiAccessDecoder.class);

    @Override
    public final Location doDecoding(OpenLRDecoderProperties prop, MapDatabase mdb, RawLocationReference rawLocRef) throws OpenLRProcessingException {
        ResolvedRoutes resolvedRoutes;
        CandidateLinesResultSet candidateLines;
        if (mdb == null) {
            return new InvalidLocation(rawLocRef.getID(), (StatusCode)DecoderReturnCode.NO_MAP_DATABASE_FOUND, LocationType.POI_WITH_ACCESS_POINT);
        }
        List lrps = rawLocRef.getLocationReferencePoints();
        Offsets od = rawLocRef.getOffsets();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"find candidate nodes");
        }
        CandidateNodesResultSet candidateNodes = this.findCandidateNodes(prop, rawLocRef, mdb);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"find candidate lines");
        }
        if (!(candidateLines = this.findCandidateLines(prop, rawLocRef, candidateNodes, mdb)).allCandidateLinesFound()) {
            return new InvalidLocation(rawLocRef.getID(), LocationType.POI_WITH_ACCESS_POINT, (StatusCode)DecoderReturnCode.NO_CANDIDATE_LINE_FOUND, rawLocRef.getGeoCoordinates(), rawLocRef.getSideOfRoad(), rawLocRef.getOrientation());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"resolve routes");
        }
        if (!(resolvedRoutes = this.resolveRoute(prop, rawLocRef, candidateLines, LocationType.POI_WITH_ACCESS_POINT)).allRoutesResolved()) {
            ArrayList<List<Line>> subRouteList = new ArrayList<List<Line>>();
            for (LocationReferencePoint p : lrps) {
                List<Line> path = resolvedRoutes.getRoute(p);
                subRouteList.add(path);
            }
            return new InvalidLocation(rawLocRef.getID(), LocationType.POI_WITH_ACCESS_POINT, resolvedRoutes.getErrorCode(), subRouteList, rawLocRef.getGeoCoordinates(), rawLocRef.getSideOfRoad(), rawLocRef.getOrientation());
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        ArrayList<List<Line>> subRoutes = new ArrayList<List<Line>>();
        for (LocationReferencePoint p : lrps) {
            List<Line> path = resolvedRoutes.getRoute(p);
            lines.addAll(path);
            subRoutes.add(path);
        }
        if (!PathUtils.checkPathConnection(lines)) {
            LOG.error((Object)"resolved path is not connected");
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.ROUTE_DISCONNECTED);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"prune location path");
        }
        int lStart = 0;
        for (Line l : (List)subRoutes.get(0)) {
            lStart += l.getLineLength();
        }
        LocationReferencePoint lrp1 = (LocationReferencePoint)lrps.get(0);
        CandidateLine cl1 = resolvedRoutes.getCandidateStart(lrp1);
        CandidateLine cl2 = resolvedRoutes.getCandidateEnd(lrp1);
        int additionalStartOffset = 0;
        int pruneAtStart = 0;
        if (cl1 != null && cl1.hasProjectionAlongLine()) {
            additionalStartOffset = cl1.getProjectionAlongLine();
            pruneAtStart += additionalStartOffset;
        }
        if (cl2 != null && cl2.hasProjectionAlongLine()) {
            pruneAtStart += cl2.getProjectionAlongLine();
        }
        int startOffset = od.getPositiveOffset(lStart - pruneAtStart) + additionalStartOffset;
        Location decoded = this.pruneAndCreateLocation(rawLocRef.getID(), lines, subRoutes, startOffset, rawLocRef);
        return decoded;
    }

    private Location pruneAndCreateLocation(String id, List<Line> location, List<List<Line>> subRoutes, int posOff, RawLocationReference rawLocRef) throws OpenLRDecoderProcessingException {
        ArrayList<Line> pruned = new ArrayList<Line>(location.size());
        pruned.addAll(location);
        int locLength = PathUtils.getLength(pruned);
        if (posOff >= 2 * locLength) {
            return new InvalidLocation(id, (StatusCode)DecoderReturnCode.INVALID_OFFSETS, LocationType.POI_WITH_ACCESS_POINT);
        }
        int pOff = posOff;
        if (posOff > locLength) {
            pOff = locLength;
        }
        int prunedLength = 0;
        int remainingPosOff = 0;
        if (pOff > 0) {
            while (true) {
                if (pruned.size() == 1) {
                    remainingPosOff = pOff - prunedLength;
                    break;
                }
                Line next = (Line)pruned.get(0);
                int length = next.getLineLength();
                if (prunedLength + length > pOff) {
                    remainingPosOff = pOff - prunedLength;
                    break;
                }
                prunedLength += length;
                pruned.remove(0);
            }
        }
        DecodedPoiAccessLocation decoded = null;
        try {
            decoded = remainingPosOff == 0 ? new DecodedPoiAccessLocation(id, (Line)pruned.get(0), subRoutes, rawLocRef.getGeoCoordinates(), rawLocRef.getSideOfRoad(), rawLocRef.getOrientation()) : new DecodedPoiAccessLocation(id, (Line)pruned.get(0), subRoutes, remainingPosOff, rawLocRef.getGeoCoordinates(), rawLocRef.getSideOfRoad(), rawLocRef.getOrientation());
        }
        catch (InvalidMapDataException e) {
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.INVALID_MAP_DATA, e);
        }
        return decoded;
    }
}

