/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker;

import java.util.List;
import openlr.OpenLRProcessingException;
import openlr.decoder.location.AffectedLinesImpl;
import openlr.decoder.location.DecodedPolygonLocation;
import openlr.decoder.properties.OpenLRDecoderProperties;
import openlr.decoder.worker.AbstractDecoder;
import openlr.decoder.worker.coverage.PolygonCoverage;
import openlr.location.Location;
import openlr.location.data.AffectedLines;
import openlr.map.MapDatabase;
import openlr.rawLocRef.RawLocationReference;

public class PolygonDecoder
extends AbstractDecoder {
    @Override
    public final Location doDecoding(OpenLRDecoderProperties prop, MapDatabase mdb, RawLocationReference rawLocRef) throws OpenLRProcessingException {
        List cornerPoints = rawLocRef.getCornerPoints();
        AffectedLines result = null;
        if (prop.isCalcAffectedLines()) {
            PolygonCoverage coverage = new PolygonCoverage(cornerPoints);
            result = coverage.getAffectedLines(mdb);
        } else {
            result = AffectedLinesImpl.EMPTY;
        }
        DecodedPolygonLocation decoded = new DecodedPolygonLocation(rawLocRef.getID(), result, cornerPoints);
        return decoded;
    }
}

