/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker;

import openlr.OpenLRProcessingException;
import openlr.decoder.OpenLRDecoderProcessingException;
import openlr.decoder.location.AffectedLinesImpl;
import openlr.decoder.location.DecodedRectangleLocation;
import openlr.decoder.properties.OpenLRDecoderProperties;
import openlr.decoder.worker.AbstractDecoder;
import openlr.decoder.worker.coverage.RectangleCoverage;
import openlr.location.Location;
import openlr.location.data.AffectedLines;
import openlr.map.GeoCoordinates;
import openlr.map.InvalidMapDataException;
import openlr.map.MapDatabase;
import openlr.rawLocRef.RawLocationReference;

public class RectangleDecoder
extends AbstractDecoder {
    @Override
    public final Location doDecoding(OpenLRDecoderProperties prop, MapDatabase mdb, RawLocationReference rawLocRef) throws OpenLRProcessingException {
        GeoCoordinates lowerLeft = rawLocRef.getLowerLeftPoint();
        GeoCoordinates upperRight = rawLocRef.getUpperRightPoint();
        AffectedLines result = null;
        if (prop.isCalcAffectedLines()) {
            RectangleCoverage coverage = null;
            try {
                coverage = new RectangleCoverage(lowerLeft, upperRight);
            }
            catch (InvalidMapDataException e) {
                throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.INVALID_MAP_DATA, e);
            }
            result = coverage.getAffectedLines(mdb);
        } else {
            result = AffectedLinesImpl.EMPTY;
        }
        DecodedRectangleLocation decoded = null;
        try {
            decoded = new DecodedRectangleLocation(rawLocRef.getID(), result, lowerLeft, upperRight);
        }
        catch (InvalidMapDataException e) {
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.INVALID_MAP_DATA, e);
        }
        return decoded;
    }
}

