/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker.coverage;

import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import openlr.decoder.OpenLRDecoderProcessingException;
import openlr.decoder.location.AffectedLinesImpl;
import openlr.location.data.AffectedLines;
import openlr.map.GeoCoordinates;
import openlr.map.InvalidMapDataException;
import openlr.map.Line;
import openlr.map.MapDatabase;

public abstract class AbstractCoverage {
    public static final int MINIMUM_ADDITIONAL_DISTANCE = 100;
    public static final int COORD_TO_INT_FACTOR = 100000;
    public static final int PATH_ITERATOR_COORDINATE_SIZE = 6;

    abstract Iterator<? extends Line> determineCoveredLines(MapDatabase var1) throws OpenLRDecoderProcessingException;

    abstract boolean isContainedIn(double var1, double var3) throws InvalidMapDataException;

    abstract boolean intersectsBoundary(GeoCoordinates var1, GeoCoordinates var2) throws InvalidMapDataException;

    public final AffectedLines getAffectedLines(MapDatabase mdb) throws OpenLRDecoderProcessingException {
        if (mdb == null) {
            return AffectedLinesImpl.EMPTY;
        }
        return this.makeCoveredAndIntersectedLinesList(this.determineCoveredLines(mdb));
    }

    final Polygon createPolygon(List<? extends GeoCoordinates> corners) {
        int[] xpoints = new int[corners.size()];
        int[] ypoints = new int[corners.size()];
        int i = 0;
        for (GeoCoordinates geoCoordinates : corners) {
            int intxrep;
            double xrep = geoCoordinates.getLongitudeDeg() * 100000.0;
            xpoints[i] = intxrep = (int)xrep;
            double yrep = geoCoordinates.getLatitudeDeg() * 100000.0;
            int intyrep = (int)yrep;
            ypoints[i++] = intyrep;
        }
        return new Polygon(xpoints, ypoints, corners.size());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final AffectedLines makeCoveredAndIntersectedLinesList(Iterator<? extends Line> coveredLinesIter) throws OpenLRDecoderProcessingException {
        ArrayList<Line> coveredLines = new ArrayList<Line>();
        ArrayList<Line> intersectedLines = new ArrayList<Line>();
        try {
            block2: while (coveredLinesIter.hasNext()) {
                int nrShapePoints;
                GeoCoordinates previous;
                boolean boundaryIntersection;
                boolean atLeastOneWasOutside;
                boolean atLeastOneWasInside;
                Iterator path;
                Line line = coveredLinesIter.next();
                List shape = line.getShapeCoordinates();
                if (shape != null) {
                    path = shape.iterator();
                    atLeastOneWasInside = false;
                    atLeastOneWasOutside = false;
                    boundaryIntersection = false;
                    previous = null;
                    nrShapePoints = 0;
                } else {
                    if ((!this.isContainedIn(line.getStartNode().getLongitudeDeg(), line.getStartNode().getLatitudeDeg()) || this.isContainedIn(line.getEndNode().getLongitudeDeg(), line.getEndNode().getLatitudeDeg())) && (this.isContainedIn(line.getStartNode().getLongitudeDeg(), line.getStartNode().getLatitudeDeg()) || !this.isContainedIn(line.getEndNode().getLongitudeDeg(), line.getEndNode().getLatitudeDeg()))) continue;
                    intersectedLines.add(line);
                    continue;
                }
                while (path.hasNext()) {
                    GeoCoordinates current = (GeoCoordinates)path.next();
                    ++nrShapePoints;
                    if (previous != null) {
                        boundaryIntersection = this.intersectsBoundary(previous, current);
                    }
                    if (this.isContainedIn(current.getLongitudeDeg(), current.getLatitudeDeg())) {
                        if (atLeastOneWasOutside) {
                            intersectedLines.add(line);
                            continue block2;
                        }
                        atLeastOneWasInside = true;
                    } else {
                        if (atLeastOneWasInside || boundaryIntersection) {
                            intersectedLines.add(line);
                            continue block2;
                        }
                        atLeastOneWasOutside = true;
                    }
                    if (!path.hasNext() && !atLeastOneWasOutside) {
                        if (nrShapePoints > 2 || this.checkMidPoint(line)) {
                            coveredLines.add(line);
                        } else {
                            intersectedLines.add(line);
                        }
                    }
                    previous = current;
                }
            }
            return new AffectedLinesImpl(coveredLines, intersectedLines);
        }
        catch (InvalidMapDataException e) {
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.INVALID_MAP_DATA, e);
        }
    }

    private boolean checkMidPoint(Line l) throws InvalidMapDataException {
        int dist = l.getLineLength() / 2;
        GeoCoordinates p = l.getGeoCoordinateAlongLine(dist);
        return this.isContainedIn(p.getLongitudeDeg(), p.getLatitudeDeg());
    }
}

