/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker.coverage;

import java.util.Iterator;
import openlr.decoder.worker.coverage.AbstractCoverage;
import openlr.map.GeoCoordinates;
import openlr.map.Line;
import openlr.map.MapDatabase;
import openlr.map.utils.GeometryUtils;

public class CircleCoverage
extends AbstractCoverage {
    private final GeoCoordinates center;
    private final long radius;

    public CircleCoverage(GeoCoordinates c, long r) {
        this.center = c;
        this.radius = r;
    }

    @Override
    final Iterator<? extends Line> determineCoveredLines(MapDatabase mdb) {
        Iterator directLinesIterator = mdb.findLinesCloseByCoordinate(this.center.getLongitudeDeg(), this.center.getLatitudeDeg(), (int)this.radius + 100);
        return directLinesIterator;
    }

    @Override
    final boolean isContainedIn(double longitude, double latitude) {
        double distance = GeometryUtils.distance((double)this.center.getLongitudeDeg(), (double)this.center.getLatitudeDeg(), (double)longitude, (double)latitude);
        return distance <= (double)this.radius;
    }

    @Override
    final boolean intersectsBoundary(GeoCoordinates gcStart, GeoCoordinates gcEnd) {
        return false;
    }
}

