/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker.coverage;

import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import openlr.decoder.worker.coverage.AbstractCoverage;
import openlr.decoder.worker.coverage.PolygonCoverage;
import openlr.map.GeoCoordinates;
import openlr.map.InvalidMapDataException;
import openlr.map.Line;
import openlr.map.MapDatabase;
import openlr.map.utils.GeometryUtils;

public class ClosedLineCoverage
extends AbstractCoverage {
    private final List<GeoCoordinates> cornerPoints;

    public ClosedLineCoverage(List<Line> l) throws InvalidMapDataException {
        this.cornerPoints = this.determinePolygon(l);
    }

    private List<GeoCoordinates> determinePolygon(List<Line> lines) throws InvalidMapDataException {
        ArrayList<GeoCoordinates> cPoints = new ArrayList<GeoCoordinates>();
        for (Line line : lines) {
            List shape = line.getShapeCoordinates();
            if (shape != null) {
                GeoCoordinates prev = null;
                for (GeoCoordinates gc : shape) {
                    if (prev == null || !gc.equals(prev)) {
                        cPoints.add(gc);
                    }
                    prev = gc;
                }
                continue;
            }
            cPoints.add(line.getStartNode().getGeoCoordinates());
        }
        return cPoints;
    }

    @Override
    final Iterator<? extends Line> determineCoveredLines(MapDatabase mdb) {
        Polygon polygon = this.createPolygon(this.cornerPoints);
        Rectangle2D bounds = polygon.getBounds2D();
        double centerLongitude = bounds.getCenterX() / 100000.0;
        double centerLatitude = bounds.getCenterY() / 100000.0;
        double topleftLongitude = bounds.getX() / 100000.0;
        double topleftLatitude = bounds.getY() / 100000.0;
        int radius = (int)GeometryUtils.distance((double)centerLongitude, (double)centerLatitude, (double)topleftLongitude, (double)topleftLatitude);
        return mdb.findLinesCloseByCoordinate(centerLongitude, centerLatitude, radius + 100);
    }

    @Override
    final boolean isContainedIn(double longitude, double latitude) throws InvalidMapDataException {
        PolygonCoverage coverage = new PolygonCoverage(this.cornerPoints);
        return coverage.isContainedIn(longitude, latitude);
    }

    @Override
    final boolean intersectsBoundary(GeoCoordinates gcStart, GeoCoordinates gcEnd) {
        PolygonCoverage coverage = new PolygonCoverage(this.cornerPoints);
        return coverage.intersectsBoundary(gcStart, gcEnd);
    }
}

