/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker.coverage;

import java.util.Iterator;
import openlr.decoder.OpenLRDecoderProcessingException;
import openlr.decoder.worker.coverage.AbstractCoverage;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.Line;
import openlr.map.MapDatabase;
import openlr.map.RectangleCorners;
import openlr.map.utils.GeometryUtils;

public class GridCoverage
extends AbstractCoverage {
    private final GeoCoordinates lowerLeft;
    private final GeoCoordinates upperRight;
    private final GeoCoordinates scaledUpperRight;
    private final int nCols;
    private final int nRows;

    public GridCoverage(GeoCoordinates ll, GeoCoordinates ur, int cols, int rows) throws InvalidMapDataException {
        this.lowerLeft = ll;
        this.upperRight = ur;
        this.nCols = cols;
        this.nRows = rows;
        this.scaledUpperRight = GeometryUtils.scaleUpperRightCoordinate((double)this.lowerLeft.getLongitudeDeg(), (double)this.lowerLeft.getLatitudeDeg(), (double)this.upperRight.getLongitudeDeg(), (double)this.upperRight.getLatitudeDeg(), (double)this.nCols, (double)this.nRows);
    }

    @Override
    final Iterator<? extends Line> determineCoveredLines(MapDatabase mdb) throws OpenLRDecoderProcessingException {
        Iterator directLinesIterator = null;
        try {
            GeoCoordinatesImpl center = new GeoCoordinatesImpl((this.lowerLeft.getLongitudeDeg() + this.scaledUpperRight.getLongitudeDeg()) / 2.0, (this.lowerLeft.getLatitudeDeg() + this.scaledUpperRight.getLatitudeDeg()) / 2.0);
            int radius = (int)GeometryUtils.distance((double)center.getLongitudeDeg(), (double)center.getLatitudeDeg(), (double)this.lowerLeft.getLongitudeDeg(), (double)this.lowerLeft.getLatitudeDeg());
            directLinesIterator = mdb.findLinesCloseByCoordinate(center.getLongitudeDeg(), center.getLatitudeDeg(), radius + 100);
        }
        catch (InvalidMapDataException e) {
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.INVALID_MAP_DATA, e);
        }
        return directLinesIterator;
    }

    @Override
    final boolean isContainedIn(double longitude, double latitude) throws InvalidMapDataException {
        return longitude >= this.lowerLeft.getLongitudeDeg() && longitude <= this.scaledUpperRight.getLongitudeDeg() && latitude >= this.lowerLeft.getLatitudeDeg() && latitude <= this.scaledUpperRight.getLatitudeDeg();
    }

    @Override
    final boolean intersectsBoundary(GeoCoordinates gcStart, GeoCoordinates gcEnd) throws InvalidMapDataException {
        RectangleCorners corners = new RectangleCorners(this.lowerLeft, this.scaledUpperRight);
        GeoCoordinates ll = corners.getLowerLeft();
        GeoCoordinates ur = corners.getUpperRight();
        GeoCoordinates ul = corners.getUpperLeft();
        GeoCoordinates lr = corners.getLowerRight();
        return GeometryUtils.lineIntersection((GeoCoordinates)gcStart, (GeoCoordinates)gcEnd, (GeoCoordinates)ll, (GeoCoordinates)lr) || GeometryUtils.lineIntersection((GeoCoordinates)gcStart, (GeoCoordinates)gcEnd, (GeoCoordinates)lr, (GeoCoordinates)ur) || GeometryUtils.lineIntersection((GeoCoordinates)gcStart, (GeoCoordinates)gcEnd, (GeoCoordinates)ur, (GeoCoordinates)ul) || GeometryUtils.lineIntersection((GeoCoordinates)gcStart, (GeoCoordinates)gcEnd, (GeoCoordinates)ul, (GeoCoordinates)ll);
    }
}

