/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker.coverage;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import openlr.decoder.worker.coverage.AbstractCoverage;
import openlr.map.GeoCoordinates;
import openlr.map.InvalidMapDataException;
import openlr.map.Line;
import openlr.map.MapDatabase;
import openlr.map.utils.GeometryUtils;

public class PolygonCoverage
extends AbstractCoverage {
    private static final double MAX_POINT_LINE_DIST = 1.0E-7;
    private final Polygon polygon;
    private final List<? extends GeoCoordinates> corners;

    public PolygonCoverage(List<? extends GeoCoordinates> c) {
        this.polygon = this.createPolygon(c);
        this.corners = c;
    }

    @Override
    final Iterator<? extends Line> determineCoveredLines(MapDatabase mdb) {
        Rectangle2D bounds = this.polygon.getBounds2D();
        double centerLongitude = bounds.getCenterX() / 100000.0;
        double centerLatitude = bounds.getCenterY() / 100000.0;
        double topleftLongitude = bounds.getX() / 100000.0;
        double topleftLatitude = bounds.getY() / 100000.0;
        int radius = (int)GeometryUtils.distance((double)centerLongitude, (double)centerLatitude, (double)topleftLongitude, (double)topleftLatitude);
        return mdb.findLinesCloseByCoordinate(centerLongitude, centerLatitude, radius + 100);
    }

    @Override
    final boolean isContainedIn(double longitude, double latitude) throws InvalidMapDataException {
        if (this.isOnBoundary(longitude, latitude)) {
            return true;
        }
        double x = longitude * 100000.0;
        int intx = (int)x;
        double y = latitude * 100000.0;
        int inty = (int)y;
        return this.polygon.contains(new Point(intx, inty));
    }

    @Override
    final boolean intersectsBoundary(GeoCoordinates gcStart, GeoCoordinates gcEnd) {
        for (int i = 0; i < this.corners.size() - 1; ++i) {
            GeoCoordinates end;
            GeoCoordinates start = this.corners.get(i);
            if (!GeometryUtils.lineIntersection((GeoCoordinates)gcStart, (GeoCoordinates)gcEnd, (GeoCoordinates)start, (GeoCoordinates)(end = this.corners.get(i + 1)))) continue;
            return true;
        }
        return GeometryUtils.lineIntersection((GeoCoordinates)gcStart, (GeoCoordinates)gcEnd, (GeoCoordinates)this.corners.get(this.corners.size() - 1), (GeoCoordinates)this.corners.get(0));
    }

    private boolean isOnBoundary(double longitude, double latitude) {
        for (int i = 0; i < this.corners.size() - 1; ++i) {
            GeoCoordinates start = this.corners.get(i);
            GeoCoordinates end = this.corners.get(i + 1);
            Line2D.Double line1 = new Line2D.Double(start.getLongitudeDeg(), start.getLatitudeDeg(), end.getLongitudeDeg(), end.getLatitudeDeg());
            if (!(line1.ptSegDist(longitude, latitude) < 1.0E-7)) continue;
            return true;
        }
        GeoCoordinates start = this.corners.get(this.corners.size() - 1);
        GeoCoordinates end = this.corners.get(0);
        Line2D.Double line1 = new Line2D.Double(start.getLongitudeDeg(), start.getLatitudeDeg(), end.getLongitudeDeg(), end.getLatitudeDeg());
        return line1.ptSegDist(longitude, latitude) < 1.0E-7;
    }
}

