/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker.coverage;

import java.util.Iterator;
import openlr.decoder.OpenLRDecoderProcessingException;
import openlr.decoder.worker.coverage.AbstractCoverage;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.Line;
import openlr.map.MapDatabase;
import openlr.map.RectangleCorners;
import openlr.map.utils.GeometryUtils;

public class RectangleCoverage
extends AbstractCoverage {
    private final RectangleCorners corners;

    public RectangleCoverage(GeoCoordinates ll, GeoCoordinates ur) throws InvalidMapDataException {
        this.corners = new RectangleCorners(ll, ur);
    }

    @Override
    public final Iterator<? extends Line> determineCoveredLines(MapDatabase mdb) throws OpenLRDecoderProcessingException {
        Iterator directLinesIterator = null;
        GeoCoordinates lowerLeft = this.corners.getLowerLeft();
        GeoCoordinates upperRight = this.corners.getUpperRight();
        try {
            GeoCoordinatesImpl center = new GeoCoordinatesImpl((lowerLeft.getLongitudeDeg() + upperRight.getLongitudeDeg()) / 2.0, (lowerLeft.getLatitudeDeg() + upperRight.getLatitudeDeg()) / 2.0);
            int radius = (int)GeometryUtils.distance((double)center.getLongitudeDeg(), (double)center.getLatitudeDeg(), (double)lowerLeft.getLongitudeDeg(), (double)lowerLeft.getLatitudeDeg());
            directLinesIterator = mdb.findLinesCloseByCoordinate(center.getLongitudeDeg(), center.getLatitudeDeg(), radius + 100);
        }
        catch (InvalidMapDataException e) {
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.INVALID_MAP_DATA, e);
        }
        return directLinesIterator;
    }

    @Override
    final boolean isContainedIn(double longitude, double latitude) {
        GeoCoordinates lowerLeft = this.corners.getLowerLeft();
        GeoCoordinates upperRight = this.corners.getUpperRight();
        return longitude >= lowerLeft.getLongitudeDeg() && longitude <= upperRight.getLongitudeDeg() && latitude >= lowerLeft.getLatitudeDeg() && latitude <= upperRight.getLatitudeDeg();
    }

    @Override
    final boolean intersectsBoundary(GeoCoordinates gcStart, GeoCoordinates gcEnd) {
        GeoCoordinates lowerLeft = this.corners.getLowerLeft();
        GeoCoordinates upperRight = this.corners.getUpperRight();
        GeoCoordinates upperLeft = this.corners.getUpperLeft();
        GeoCoordinates lowerRight = this.corners.getLowerRight();
        return GeometryUtils.lineIntersection((GeoCoordinates)gcStart, (GeoCoordinates)gcEnd, (GeoCoordinates)lowerLeft, (GeoCoordinates)lowerRight) || GeometryUtils.lineIntersection((GeoCoordinates)gcStart, (GeoCoordinates)gcEnd, (GeoCoordinates)lowerRight, (GeoCoordinates)upperRight) || GeometryUtils.lineIntersection((GeoCoordinates)gcStart, (GeoCoordinates)gcEnd, (GeoCoordinates)upperRight, (GeoCoordinates)upperLeft) || GeometryUtils.lineIntersection((GeoCoordinates)gcStart, (GeoCoordinates)gcEnd, (GeoCoordinates)upperLeft, (GeoCoordinates)lowerLeft);
    }
}

