/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml;

import java.util.ArrayList;
import java.util.List;
import openlr.StatusCode;
import openlr.xml.OpenLRXMLException;
import openlr.xml.generated.BinaryLocationReference;
import openlr.xml.generated.BinaryLocationReferences;
import openlr.xml.generated.ObjectFactory;
import openlr.xml.generated.OpenLR;
import openlr.xml.generated.XMLLocationReference;

public final class BinaryLocRefHandler {
    private BinaryLocRefHandler() {
        throw new UnsupportedOperationException();
    }

    public static OpenLR createXmlWithBinaryData(List<BinaryLocationReferenceData> data) {
        ObjectFactory of = new ObjectFactory();
        OpenLR xmlData = of.createOpenLR();
        BinaryLocationReferences bins = of.createBinaryLocationReferences();
        xmlData.setBinaryLocationReferences(bins);
        for (BinaryLocationReferenceData b : data) {
            BinaryLocationReference binRef = of.createBinaryLocationReference();
            binRef.setId(b.getId());
            binRef.setVersion(Integer.toString(b.getVersion()));
            binRef.setValue(b.getData());
            bins.getBinaryLocationReference().add(binRef);
        }
        return xmlData;
    }

    public static List<BinaryLocationReferenceData> resolveBinaryDatafromXML(OpenLR xmlData) throws OpenLRXMLException {
        BinaryLocationReferences binaries = xmlData.getBinaryLocationReferences();
        if (binaries == null) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "no binary location reference");
        }
        List<BinaryLocationReference> binariesData = binaries.getBinaryLocationReference();
        if (binariesData == null || binariesData.isEmpty()) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "no valid binary location reference");
        }
        ArrayList<BinaryLocationReferenceData> bins = new ArrayList<BinaryLocationReferenceData>();
        for (BinaryLocationReference b : binariesData) {
            int version = -1;
            try {
                version = Integer.parseInt(b.getVersion());
                if (b.getValue().length > 0) {
                    bins.add(new BinaryLocationReferenceData(b.getId(), version, b.getValue()));
                    continue;
                }
                throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "Binary location reference without value: " + b.getId());
            }
            catch (NumberFormatException nfe) {
                throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.INVALID_VERSION, "Invalid version in OpenLR location reference: " + b.getVersion());
            }
        }
        return bins;
    }

    public static boolean containsBinaryLocationReference(OpenLR xmlData) {
        List<BinaryLocationReference> binaryLocationReference;
        return xmlData.getBinaryLocationReferences() != null && (binaryLocationReference = xmlData.getBinaryLocationReferences().getBinaryLocationReference()) != null && !binaryLocationReference.isEmpty();
    }

    public static boolean containsXmlLocationReference(OpenLR xmlData) {
        XMLLocationReference xmlLocationReference = xmlData.getXMLLocationReference();
        return xmlLocationReference != null && (xmlLocationReference.getLineLocationReference() != null || xmlLocationReference.getPointLocationReference() != null);
    }

    public static class BinaryLocationReferenceData {
        private final String id;
        private final int version;
        private final byte[] data;

        public BinaryLocationReferenceData(String i, int v, byte[] d) {
            this.id = i;
            this.version = v;
            this.data = (byte[])d.clone();
        }

        public final String getId() {
            return this.id;
        }

        public final int getVersion() {
            return this.version;
        }

        public final byte[] getData() {
            return (byte[])this.data.clone();
        }
    }
}

