/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml;

import openlr.LocationType;
import openlr.xml.generated.AreaLocationReference;
import openlr.xml.generated.LineLocationReference;
import openlr.xml.generated.OpenLR;
import openlr.xml.generated.PointLocationReference;
import openlr.xml.generated.XMLLocationReference;

public final class LocationReferenceXmlHelper {
    private LocationReferenceXmlHelper() {
        throw new UnsupportedOperationException();
    }

    public static LocationType resolveLocationType(OpenLR xmlData) {
        XMLLocationReference locref;
        LocationType lt = LocationType.UNKNOWN;
        if (xmlData != null && (locref = xmlData.getXMLLocationReference()) != null) {
            LineLocationReference linelocref = locref.getLineLocationReference();
            PointLocationReference pointlocref = locref.getPointLocationReference();
            AreaLocationReference areaLocRef = locref.getAreaLocationReference();
            if (linelocref != null) {
                lt = LocationType.LINE_LOCATION;
            } else if (pointlocref != null) {
                if (pointlocref.getGeoCoordinate() != null) {
                    lt = LocationType.GEO_COORDINATES;
                } else if (pointlocref.getPointAlongLine() != null) {
                    lt = LocationType.POINT_ALONG_LINE;
                } else if (pointlocref.getPoiWithAccessPoint() != null) {
                    lt = LocationType.POI_WITH_ACCESS_POINT;
                }
            } else if (areaLocRef != null) {
                if (areaLocRef.getCircleLocationReference() != null) {
                    lt = LocationType.CIRCLE;
                } else if (areaLocRef.getClosedLineLocationReference() != null) {
                    lt = LocationType.CLOSED_LINE;
                } else if (areaLocRef.getGridLocationReference() != null) {
                    lt = LocationType.GRID;
                } else if (areaLocRef.getRectangleLocationReference() != null) {
                    lt = LocationType.RECTANGLE;
                } else if (areaLocRef.getPolygonLocationReference() != null) {
                    lt = LocationType.POLYGON;
                }
            }
        }
        return lt;
    }
}

