/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml;

import openlr.LocationReference;
import openlr.LocationType;
import openlr.PhysicalEncoder;
import openlr.rawLocRef.RawLocationReference;
import openlr.xml.XmlReturnCode;
import openlr.xml.encoder.AbstractEncoder;
import openlr.xml.encoder.CircleEncoder;
import openlr.xml.encoder.ClosedLineEncoder;
import openlr.xml.encoder.GeoCoordEncoder;
import openlr.xml.encoder.GridEncoder;
import openlr.xml.encoder.LineEncoder;
import openlr.xml.encoder.PoiAccessEncoder;
import openlr.xml.encoder.PointAlongEncoder;
import openlr.xml.encoder.PolygonEncoder;
import openlr.xml.encoder.RectangleEncoder;
import openlr.xml.generated.OpenLR;
import openlr.xml.impl.LocationReferenceXmlImpl;

public class OpenLRXMLEncoder
implements PhysicalEncoder {
    private static final int[] VERSIONS = new int[]{1};

    public final Class<?> getDataClass() {
        return OpenLR.class;
    }

    public final String getDataFormatIdentifier() {
        return "xml";
    }

    public final int[] getSupportedVersions() {
        return (int[])VERSIONS.clone();
    }

    public final LocationReference encodeData(RawLocationReference rawLocRef) {
        return this.encodeData(rawLocRef, VERSIONS[VERSIONS.length - 1]);
    }

    private boolean checkVersion(int ver) {
        for (int v : VERSIONS) {
            if (v != ver) continue;
            return true;
        }
        return false;
    }

    public final LocationReference encodeData(RawLocationReference rawLocRef, int version) {
        if (!this.checkVersion(version)) {
            return new LocationReferenceXmlImpl(rawLocRef.getID(), XmlReturnCode.INVALID_VERSION, rawLocRef.getLocationType(), version);
        }
        LocationType lt = rawLocRef.getLocationType();
        AbstractEncoder encoder = null;
        switch (lt) {
            case GEO_COORDINATES: {
                encoder = new GeoCoordEncoder();
                break;
            }
            case LINE_LOCATION: {
                encoder = new LineEncoder();
                break;
            }
            case POI_WITH_ACCESS_POINT: {
                encoder = new PoiAccessEncoder();
                break;
            }
            case POINT_ALONG_LINE: {
                encoder = new PointAlongEncoder();
                break;
            }
            case CIRCLE: {
                encoder = new CircleEncoder();
                break;
            }
            case RECTANGLE: {
                encoder = new RectangleEncoder();
                break;
            }
            case GRID: {
                encoder = new GridEncoder();
                break;
            }
            case POLYGON: {
                encoder = new PolygonEncoder();
                break;
            }
            case CLOSED_LINE: {
                encoder = new ClosedLineEncoder();
                break;
            }
            default: {
                return new LocationReferenceXmlImpl(rawLocRef.getID(), XmlReturnCode.UNKNOWN_LOCATION_TYPE, rawLocRef.getLocationType(), version);
            }
        }
        LocationReference lr = encoder.encodeData(rawLocRef, version);
        return lr;
    }
}

