/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import openlr.StatusCode;
import openlr.xml.OpenLRXMLException;
import openlr.xml.generated.ObjectFactory;
import openlr.xml.generated.OpenLR;
import org.xml.sax.SAXException;

public class OpenLRXmlReader {
    private static final String XML_SCHEMA_OPENLR = "openlr.xsd";
    private static final URL OPENLR_XSD = OpenLRXmlReader.class.getClassLoader().getResource("openlr.xsd");
    private static final Class<?> OPENLR_OBJECT_FACTORY = ObjectFactory.class;
    private static final Object SYNC_OBJECT = new Object();
    private final JAXBContext jc;
    private final Schema schema;

    public OpenLRXmlReader() throws OpenLRXMLException {
        if (OPENLR_XSD == null) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.XSD_ERROR, "schema file not found");
        }
        try {
            this.jc = JAXBContext.newInstance((Class[])new Class[]{OPENLR_OBJECT_FACTORY});
        }
        catch (JAXBException e) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.XML_ERROR, e);
        }
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            this.schema = sf.newSchema(OPENLR_XSD);
        }
        catch (SAXException e) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.XSD_ERROR, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final OpenLR readOpenLRXML(File file, boolean validate) throws JAXBException, SAXException, IOException {
        OpenLR result = null;
        if (file != null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                Unmarshaller unmarshaller = this.jc.createUnmarshaller();
                if (validate) {
                    unmarshaller.setSchema(this.schema);
                }
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                result = (OpenLR)unmarshaller.unmarshal((Source)new StreamSource(is), OpenLR.class).getValue();
                ((InputStream)is).close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final OpenLR readOpenLRXML(InputStream is, boolean validate) throws JAXBException, SAXException {
        OpenLR result = null;
        if (is != null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                Unmarshaller unmarshaller = this.jc.createUnmarshaller();
                if (validate) {
                    unmarshaller.setSchema(this.schema);
                }
                result = (OpenLR)unmarshaller.unmarshal((Source)new StreamSource(new BufferedInputStream(is)), OpenLR.class).getValue();
            }
        }
        return result;
    }
}

