/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import openlr.xml.generated.OpenLR;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class OpenLRXmlWriter {
    private static final Logger LOG = Logger.getLogger(OpenLRXmlWriter.class);
    private static final String XML_SCHEMA_OPENLR = "openlr.xsd";
    private static final URL OPENLR_XSD = OpenLRXmlWriter.class.getClassLoader().getResource("openlr.xsd");
    private static final Object SYNC_OBJECT = new Object();
    private final JAXBContext jaxbContext;
    private final Schema schema;

    public OpenLRXmlWriter() throws IOException {
        if (OPENLR_XSD == null) {
            throw new IOException("schema file not found");
        }
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{OpenLR.class});
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            this.schema = sf.newSchema(OPENLR_XSD);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveOpenLRXML(OpenLR data, FileWriter fw, boolean validate) throws JAXBException, SAXException {
        if (data != null && fw != null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                Marshaller marshaller = this.jaxbContext.createMarshaller();
                if (validate) {
                    marshaller.setSchema(this.schema);
                }
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.marshal((Object)data, (Writer)fw);
            }
        } else {
            LOG.error((Object)"cannot save data as data or stream is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveOpenLRXML(OpenLR data, OutputStream os, boolean validate) throws JAXBException, SAXException {
        if (data != null && os != null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                Marshaller marshaller = this.jaxbContext.createMarshaller();
                if (validate) {
                    marshaller.setSchema(this.schema);
                }
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.marshal((Object)data, os);
            }
        }
    }
}

