/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.decoder;

import java.math.BigInteger;
import openlr.LocationReferencePoint;
import openlr.Offsets;
import openlr.PhysicalFormatException;
import openlr.StatusCode;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.map.FormOfWay;
import openlr.map.FunctionalRoadClass;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.rawLocRef.RawLocationReference;
import openlr.xml.OpenLRXMLException;
import openlr.xml.generated.Coordinates;
import openlr.xml.generated.FOWType;
import openlr.xml.generated.FRCType;
import openlr.xml.generated.LastLocationReferencePoint;
import openlr.xml.generated.LineAttributes;
import openlr.xml.generated.OrientationType;
import openlr.xml.generated.PathAttributes;
import openlr.xml.generated.SideOfRoadType;
import openlr.xml.impl.LocationReferencePointXmlImpl;
import openlr.xml.impl.OffsetsXmlImpl;

public abstract class AbstractDecoder {
    public abstract RawLocationReference decodeData(String var1, Object var2) throws PhysicalFormatException;

    protected final Orientation resolveOrientation(OrientationType orientation) {
        Orientation o = null;
        switch (orientation) {
            case NO_ORIENTATION_OR_UNKNOWN: {
                o = Orientation.NO_ORIENTATION_OR_UNKNOWN;
                break;
            }
            case WITH_LINE_DIRECTION: {
                o = Orientation.WITH_LINE_DIRECTION;
                break;
            }
            case AGAINST_LINE_DIRECTION: {
                o = Orientation.AGAINST_LINE_DIRECTION;
                break;
            }
            case BOTH: {
                o = Orientation.BOTH;
                break;
            }
            default: {
                o = Orientation.getDefault();
            }
        }
        return o;
    }

    protected final SideOfRoad resolveSideOfRoad(SideOfRoadType sideOfRoad) {
        SideOfRoad s = null;
        switch (sideOfRoad) {
            case ON_ROAD_OR_UNKNOWN: {
                s = SideOfRoad.ON_ROAD_OR_UNKNOWN;
                break;
            }
            case RIGHT: {
                s = SideOfRoad.RIGHT;
                break;
            }
            case LEFT: {
                s = SideOfRoad.LEFT;
                break;
            }
            case BOTH: {
                s = SideOfRoad.BOTH;
                break;
            }
            default: {
                s = SideOfRoad.getDefault();
            }
        }
        return s;
    }

    protected final GeoCoordinates createGeoCoord(Coordinates c) throws OpenLRXMLException {
        if (c == null) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "no coordinates found");
        }
        GeoCoordinatesImpl gc = null;
        try {
            gc = new GeoCoordinatesImpl(c.getLongitude(), c.getLatitude());
        }
        catch (InvalidMapDataException e) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "coordinates out of bounds");
        }
        return gc;
    }

    protected final LocationReferencePoint createLastLRP(int seqNr, LastLocationReferencePoint lastLRP) throws OpenLRXMLException {
        Coordinates coord = lastLRP.getCoordinates();
        if (coord == null) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "invalid coordinates");
        }
        double lon = coord.getLongitude();
        double lat = coord.getLatitude();
        LineAttributes lineAttr = lastLRP.getLineAttributes();
        if (lineAttr == null) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "invalid line attributes");
        }
        double bearing = lineAttr.getBEAR();
        FunctionalRoadClass frc = this.mapFRC(lineAttr.getFRC());
        FormOfWay fow = this.mapFOW(lineAttr.getFOW());
        return new LocationReferencePointXmlImpl(seqNr, frc, fow, lon, lat, bearing, 0, null, true);
    }

    protected final FormOfWay mapFOW(FOWType fow) {
        FormOfWay f = null;
        switch (fow) {
            case MOTORWAY: {
                f = FormOfWay.MOTORWAY;
                break;
            }
            case MULTIPLE_CARRIAGEWAY: {
                f = FormOfWay.MULTIPLE_CARRIAGEWAY;
                break;
            }
            case OTHER: {
                f = FormOfWay.OTHER;
                break;
            }
            case ROUNDABOUT: {
                f = FormOfWay.ROUNDABOUT;
                break;
            }
            case SINGLE_CARRIAGEWAY: {
                f = FormOfWay.SINGLE_CARRIAGEWAY;
                break;
            }
            case SLIPROAD: {
                f = FormOfWay.SLIPROAD;
                break;
            }
            case TRAFFICSQUARE: {
                f = FormOfWay.TRAFFIC_SQUARE;
                break;
            }
            case UNDEFINED: {
                f = FormOfWay.UNDEFINED;
                break;
            }
            default: {
                f = null;
            }
        }
        return f;
    }

    protected final FunctionalRoadClass mapFRC(FRCType frc) {
        FunctionalRoadClass f = null;
        switch (frc) {
            case FRC_0: {
                f = FunctionalRoadClass.FRC_0;
                break;
            }
            case FRC_1: {
                f = FunctionalRoadClass.FRC_1;
                break;
            }
            case FRC_2: {
                f = FunctionalRoadClass.FRC_2;
                break;
            }
            case FRC_3: {
                f = FunctionalRoadClass.FRC_3;
                break;
            }
            case FRC_4: {
                f = FunctionalRoadClass.FRC_4;
                break;
            }
            case FRC_5: {
                f = FunctionalRoadClass.FRC_5;
                break;
            }
            case FRC_6: {
                f = FunctionalRoadClass.FRC_6;
                break;
            }
            case FRC_7: {
                f = FunctionalRoadClass.FRC_7;
                break;
            }
            default: {
                f = null;
            }
        }
        return f;
    }

    protected final LocationReferencePoint createLRP(int seqNr, openlr.xml.generated.LocationReferencePoint xmlLRP) throws OpenLRXMLException {
        Coordinates coord = xmlLRP.getCoordinates();
        if (coord == null) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "invalid coordinates");
        }
        double lon = coord.getLongitude();
        double lat = coord.getLatitude();
        LineAttributes lineAttr = xmlLRP.getLineAttributes();
        if (lineAttr == null) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "invalid line attributes");
        }
        double bearing = lineAttr.getBEAR();
        FunctionalRoadClass frc = this.mapFRC(lineAttr.getFRC());
        FormOfWay fow = this.mapFOW(lineAttr.getFOW());
        PathAttributes pathAttr = xmlLRP.getPathAttributes();
        if (pathAttr == null) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "invalid path attributes");
        }
        BigInteger xmlDNP = pathAttr.getDNP();
        if (xmlDNP == null) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "invalid dnp attribute");
        }
        int dnp = xmlDNP.intValue();
        FunctionalRoadClass lfrc = this.mapFRC(pathAttr.getLFRCNP());
        return new LocationReferencePointXmlImpl(seqNr, frc, fow, lon, lat, bearing, dnp, lfrc, false);
    }

    protected final Offsets readOffsets(openlr.xml.generated.Offsets xmlOffsets) throws OpenLRXMLException {
        if (xmlOffsets == null) {
            return new OffsetsXmlImpl(0, 0);
        }
        BigInteger poff = xmlOffsets.getPosOff();
        BigInteger noff = xmlOffsets.getNegOff();
        int pValue = 0;
        int nValue = 0;
        if (poff != null) {
            pValue = poff.intValue();
        }
        if (noff != null) {
            nValue = noff.intValue();
        }
        return new OffsetsXmlImpl(pValue, nValue);
    }
}

