/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.decoder;

import openlr.LocationType;
import openlr.PhysicalFormatException;
import openlr.StatusCode;
import openlr.rawLocRef.RawCircleLocRef;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLocationReference;
import openlr.xml.OpenLRXMLException;
import openlr.xml.XmlReturnCode;
import openlr.xml.decoder.AbstractDecoder;
import openlr.xml.generated.CircleLocationReference;
import openlr.xml.generated.GeoCoordinate;

public class CircleDecoder
extends AbstractDecoder {
    @Override
    public final RawLocationReference decodeData(String id, Object data) throws PhysicalFormatException {
        if (!(data instanceof CircleLocationReference)) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "incorrect data class");
        }
        CircleLocationReference circleLoc = (CircleLocationReference)data;
        long radius = circleLoc.getRadius().longValue();
        GeoCoordinate centerPoint = circleLoc.getGeoCoordinate();
        if (centerPoint == null || radius < 0L) {
            return new RawInvalidLocRef(id, (StatusCode)XmlReturnCode.MISSING_CIRCLE_DATA, LocationType.CIRCLE);
        }
        RawCircleLocRef rawLocRef = new RawCircleLocRef(id, this.createGeoCoord(centerPoint.getCoordinates()), radius);
        return rawLocRef;
    }
}

