/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.decoder;

import java.util.ArrayList;
import java.util.List;
import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.PhysicalFormatException;
import openlr.StatusCode;
import openlr.rawLocRef.RawClosedLineLocRef;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLocationReference;
import openlr.xml.OpenLRXMLException;
import openlr.xml.XmlReturnCode;
import openlr.xml.decoder.AbstractDecoder;
import openlr.xml.generated.ClosedLineLocationReference;
import openlr.xml.generated.LineAttributes;
import openlr.xml.impl.LocationReferencePointXmlImpl;

public class ClosedLineDecoder
extends AbstractDecoder {
    @Override
    public final RawLocationReference decodeData(String id, Object data) throws PhysicalFormatException {
        if (!(data instanceof ClosedLineLocationReference)) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "incorrect data class");
        }
        ClosedLineLocationReference closedLineLoc = (ClosedLineLocationReference)data;
        ArrayList<LocationReferencePoint> points = new ArrayList<LocationReferencePoint>();
        List<openlr.xml.generated.LocationReferencePoint> locPoints = closedLineLoc.getLocationReferencePoint();
        if (locPoints == null || locPoints.isEmpty()) {
            return new RawInvalidLocRef(id, (StatusCode)XmlReturnCode.INVALID_NUMBER_OF_LRP, LocationType.CLOSED_LINE);
        }
        int lrpCount = 1;
        for (openlr.xml.generated.LocationReferencePoint xmlLRP : locPoints) {
            points.add(this.createLRP(lrpCount, xmlLRP));
            ++lrpCount;
        }
        LineAttributes lastLine = closedLineLoc.getLastLine();
        openlr.xml.generated.LocationReferencePoint firstLRP = locPoints.get(0);
        LocationReferencePointXmlImpl lastLRP = new LocationReferencePointXmlImpl(lrpCount, this.mapFRC(lastLine.getFRC()), this.mapFOW(lastLine.getFOW()), firstLRP.getCoordinates().getLongitude(), firstLRP.getCoordinates().getLatitude(), lastLine.getBEAR(), 0, null, true);
        points.add(lastLRP);
        RawClosedLineLocRef rawLocRef = new RawClosedLineLocRef(id, points);
        return rawLocRef;
    }
}

