/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.decoder;

import openlr.LocationType;
import openlr.PhysicalFormatException;
import openlr.StatusCode;
import openlr.rawLocRef.RawGridLocRef;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLocationReference;
import openlr.xml.OpenLRXMLException;
import openlr.xml.XmlReturnCode;
import openlr.xml.decoder.AbstractDecoder;
import openlr.xml.generated.Coordinates;
import openlr.xml.generated.GridLocationReference;
import openlr.xml.generated.Rectangle;

public class GridDecoder
extends AbstractDecoder {
    @Override
    public final RawLocationReference decodeData(String id, Object data) throws PhysicalFormatException {
        if (!(data instanceof GridLocationReference)) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "incorrect data class");
        }
        GridLocationReference gridLoc = (GridLocationReference)data;
        Rectangle rect = gridLoc.getRectangle();
        if (rect == null) {
            return new RawInvalidLocRef(id, (StatusCode)XmlReturnCode.MISSING_GRID_DATA, LocationType.GRID);
        }
        Coordinates lowerLeftPoint = rect.getLowerLeft();
        Coordinates upperRightPoint = rect.getUpperRight();
        if (lowerLeftPoint == null || upperRightPoint == null) {
            return new RawInvalidLocRef(id, (StatusCode)XmlReturnCode.MISSING_GRID_DATA, LocationType.GRID);
        }
        short ncols = gridLoc.getNumColumns();
        short nrows = gridLoc.getNumRows();
        RawGridLocRef rawLocRef = new RawGridLocRef(id, this.createGeoCoord(lowerLeftPoint), this.createGeoCoord(upperRightPoint), (int)ncols, (int)nrows);
        return rawLocRef;
    }
}

