/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.decoder;

import java.util.ArrayList;
import java.util.List;
import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.Offsets;
import openlr.PhysicalFormatException;
import openlr.StatusCode;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLineLocRef;
import openlr.rawLocRef.RawLocationReference;
import openlr.xml.OpenLRXMLException;
import openlr.xml.XmlReturnCode;
import openlr.xml.decoder.AbstractDecoder;
import openlr.xml.generated.LastLocationReferencePoint;
import openlr.xml.generated.LineLocationReference;

public class LineDecoder
extends AbstractDecoder {
    @Override
    public final RawLocationReference decodeData(String id, Object data) throws PhysicalFormatException {
        if (!(data instanceof LineLocationReference)) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "incorrect data class");
        }
        LineLocationReference lineLoc = (LineLocationReference)data;
        ArrayList<LocationReferencePoint> points = new ArrayList<LocationReferencePoint>();
        List<openlr.xml.generated.LocationReferencePoint> locPoints = lineLoc.getLocationReferencePoint();
        if (locPoints == null || locPoints.isEmpty()) {
            return new RawInvalidLocRef(id, (StatusCode)XmlReturnCode.INVALID_NUMBER_OF_LRP, LocationType.LINE_LOCATION);
        }
        int lrpCount = 1;
        Offsets offsets = this.readOffsets(lineLoc.getOffsets());
        for (openlr.xml.generated.LocationReferencePoint xmlLRP : locPoints) {
            points.add(this.createLRP(lrpCount, xmlLRP));
            ++lrpCount;
        }
        LastLocationReferencePoint lastLRP = lineLoc.getLastLocationReferencePoint();
        if (lastLRP == null) {
            return new RawInvalidLocRef(id, (StatusCode)XmlReturnCode.NO_LAST_LRP_FOUND, LocationType.LINE_LOCATION);
        }
        points.add(this.createLastLRP(lrpCount, lastLRP));
        RawLineLocRef rawLocRef = new RawLineLocRef(id, points, offsets);
        return rawLocRef;
    }
}

