/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.decoder;

import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.Offsets;
import openlr.PhysicalFormatException;
import openlr.StatusCode;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.map.GeoCoordinates;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLocationReference;
import openlr.rawLocRef.RawPoiAccessLocRef;
import openlr.xml.OpenLRXMLException;
import openlr.xml.XmlReturnCode;
import openlr.xml.decoder.AbstractDecoder;
import openlr.xml.generated.LastLocationReferencePoint;
import openlr.xml.generated.PoiWithAccessPoint;

public class PoiAccessDecoder
extends AbstractDecoder {
    @Override
    public final RawLocationReference decodeData(String id, Object data) throws PhysicalFormatException {
        if (!(data instanceof PoiWithAccessPoint)) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "incorrect data class");
        }
        PoiWithAccessPoint palwap = (PoiWithAccessPoint)data;
        openlr.xml.generated.LocationReferencePoint startLRP = palwap.getLocationReferencePoint();
        LastLocationReferencePoint endLRP = palwap.getLastLocationReferencePoint();
        if (startLRP == null || endLRP == null) {
            return new RawInvalidLocRef(id, (StatusCode)XmlReturnCode.INVALID_NUMBER_OF_LRP, LocationType.POI_WITH_ACCESS_POINT);
        }
        Offsets offsets = this.readOffsets(palwap.getOffsets());
        LocationReferencePoint lrp01 = this.createLRP(1, startLRP);
        LocationReferencePoint lrp02 = this.createLastLRP(2, endLRP);
        GeoCoordinates geoCoord = this.createGeoCoord(palwap.getCoordinates());
        SideOfRoad sideOfRoad = SideOfRoad.getDefault();
        if (palwap.getSideOfRoad() != null) {
            sideOfRoad = this.resolveSideOfRoad(palwap.getSideOfRoad());
        }
        Orientation orientation = Orientation.getDefault();
        if (palwap.getOrientation() != null) {
            orientation = this.resolveOrientation(palwap.getOrientation());
        }
        RawPoiAccessLocRef rawLocRef = new RawPoiAccessLocRef(id, lrp01, lrp02, offsets, geoCoord, sideOfRoad, orientation);
        return rawLocRef;
    }
}

