/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.decoder;

import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.Offsets;
import openlr.PhysicalFormatException;
import openlr.StatusCode;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLocationReference;
import openlr.rawLocRef.RawPointAlongLocRef;
import openlr.xml.OpenLRXMLException;
import openlr.xml.XmlReturnCode;
import openlr.xml.decoder.AbstractDecoder;
import openlr.xml.generated.LastLocationReferencePoint;
import openlr.xml.generated.PointAlongLine;

public class PointAlongDecoder
extends AbstractDecoder {
    @Override
    public final RawLocationReference decodeData(String id, Object data) throws PhysicalFormatException {
        if (!(data instanceof PointAlongLine)) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "incorrect data class");
        }
        PointAlongLine pal = (PointAlongLine)data;
        openlr.xml.generated.LocationReferencePoint startLRP = pal.getLocationReferencePoint();
        LastLocationReferencePoint endLRP = pal.getLastLocationReferencePoint();
        if (startLRP == null || endLRP == null) {
            return new RawInvalidLocRef(id, (StatusCode)XmlReturnCode.INVALID_NUMBER_OF_LRP, LocationType.POINT_ALONG_LINE);
        }
        Offsets offsets = this.readOffsets(pal.getOffsets());
        LocationReferencePoint lrp01 = this.createLRP(1, startLRP);
        LocationReferencePoint lrp02 = this.createLastLRP(2, endLRP);
        SideOfRoad sideOfRoad = SideOfRoad.getDefault();
        if (pal.getSideOfRoad() != null) {
            sideOfRoad = this.resolveSideOfRoad(pal.getSideOfRoad());
        }
        Orientation orientation = Orientation.getDefault();
        if (pal.getOrientation() != null) {
            orientation = this.resolveOrientation(pal.getOrientation());
        }
        RawPointAlongLocRef rawLocRef = new RawPointAlongLocRef(id, lrp01, lrp02, offsets, sideOfRoad, orientation);
        return rawLocRef;
    }
}

