/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.decoder;

import java.util.ArrayList;
import java.util.List;
import openlr.LocationType;
import openlr.PhysicalFormatException;
import openlr.StatusCode;
import openlr.map.GeoCoordinates;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLocationReference;
import openlr.rawLocRef.RawPolygonLocRef;
import openlr.xml.OpenLRXMLException;
import openlr.xml.XmlReturnCode;
import openlr.xml.decoder.AbstractDecoder;
import openlr.xml.generated.Coordinates;
import openlr.xml.generated.PolygonLocationReference;

public class PolygonDecoder
extends AbstractDecoder {
    private static final int MIN_NUMBER_CORNERS = 3;

    @Override
    public final RawLocationReference decodeData(String id, Object data) throws PhysicalFormatException {
        if (!(data instanceof PolygonLocationReference)) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "incorrect data class");
        }
        PolygonLocationReference polygonLoc = (PolygonLocationReference)data;
        List<Coordinates> corners = polygonLoc.getPolygonCorners().getCoordinates();
        if (corners == null || corners.size() < 3) {
            return new RawInvalidLocRef(id, (StatusCode)XmlReturnCode.MISSING_POLYGON_DATA, LocationType.POLYGON);
        }
        ArrayList<GeoCoordinates> cornerPoints = new ArrayList<GeoCoordinates>();
        for (Coordinates geoCoord : corners) {
            cornerPoints.add(this.createGeoCoord(geoCoord));
        }
        RawPolygonLocRef rawLocRef = new RawPolygonLocRef(id, cornerPoints);
        return rawLocRef;
    }
}

