/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.decoder;

import openlr.LocationType;
import openlr.PhysicalFormatException;
import openlr.StatusCode;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLocationReference;
import openlr.rawLocRef.RawRectangleLocRef;
import openlr.xml.OpenLRXMLException;
import openlr.xml.XmlReturnCode;
import openlr.xml.decoder.AbstractDecoder;
import openlr.xml.generated.Coordinates;
import openlr.xml.generated.Rectangle;
import openlr.xml.generated.RectangleLocationReference;

public class RectangleDecoder
extends AbstractDecoder {
    @Override
    public final RawLocationReference decodeData(String id, Object data) throws PhysicalFormatException {
        if (!(data instanceof RectangleLocationReference)) {
            throw new OpenLRXMLException((StatusCode)OpenLRXMLException.XMLErrorType.DATA_ERROR, "incorrect data class");
        }
        RectangleLocationReference rectangleLoc = (RectangleLocationReference)data;
        Rectangle rect = rectangleLoc.getRectangle();
        if (rect == null) {
            return new RawInvalidLocRef(id, (StatusCode)XmlReturnCode.MISSING_RECTANGLE_DATA, LocationType.RECTANGLE);
        }
        Coordinates lowerLeftPoint = rect.getLowerLeft();
        Coordinates upperRightPoint = rect.getUpperRight();
        if (lowerLeftPoint == null || upperRightPoint == null) {
            return new RawInvalidLocRef(id, (StatusCode)XmlReturnCode.MISSING_RECTANGLE_DATA, LocationType.RECTANGLE);
        }
        RawRectangleLocRef rawLocRef = new RawRectangleLocRef(id, this.createGeoCoord(lowerLeftPoint), this.createGeoCoord(upperRightPoint));
        return rawLocRef;
    }
}

