/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.encoder;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import openlr.LocationReference;
import openlr.LocationReferencePoint;
import openlr.Offsets;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.map.FormOfWay;
import openlr.map.FunctionalRoadClass;
import openlr.map.GeoCoordinates;
import openlr.rawLocRef.RawLocationReference;
import openlr.xml.OpenLRXMLConstants;
import openlr.xml.generated.Coordinates;
import openlr.xml.generated.FOWType;
import openlr.xml.generated.FRCType;
import openlr.xml.generated.LastLocationReferencePoint;
import openlr.xml.generated.LineAttributes;
import openlr.xml.generated.ObjectFactory;
import openlr.xml.generated.OrientationType;
import openlr.xml.generated.PathAttributes;
import openlr.xml.generated.SideOfRoadType;

public abstract class AbstractEncoder {
    public static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();

    public abstract LocationReference encodeData(RawLocationReference var1, int var2);

    protected final LastLocationReferencePoint createLastLRP(List<? extends LocationReferencePoint> locRef) {
        LastLocationReferencePoint llrp = OBJECT_FACTORY.createLastLocationReferencePoint();
        LocationReferencePoint l = locRef.get(locRef.size() - 1);
        Coordinates coord = this.createCoordinates(l);
        llrp.setCoordinates(coord);
        LineAttributes lineAttr = this.createLineAttr(l);
        llrp.setLineAttributes(lineAttr);
        return llrp;
    }

    protected final List<openlr.xml.generated.LocationReferencePoint> createClosedLineLRPs(List<? extends LocationReferencePoint> locRef) {
        ArrayList<openlr.xml.generated.LocationReferencePoint> points = new ArrayList<openlr.xml.generated.LocationReferencePoint>();
        for (int i = 0; i < locRef.size() - 1; ++i) {
            LocationReferencePoint lrp = locRef.get(i);
            points.add(this.createLRP(lrp));
        }
        return points;
    }

    protected final List<openlr.xml.generated.LocationReferencePoint> createLRPs(List<? extends LocationReferencePoint> locRef) {
        ArrayList<openlr.xml.generated.LocationReferencePoint> points = new ArrayList<openlr.xml.generated.LocationReferencePoint>();
        for (int i = 0; i < locRef.size() - 1; ++i) {
            LocationReferencePoint lrp = locRef.get(i);
            points.add(this.createLRP(lrp));
        }
        return points;
    }

    protected final openlr.xml.generated.LocationReferencePoint createLRP(LocationReferencePoint lrp) {
        openlr.xml.generated.LocationReferencePoint l = OBJECT_FACTORY.createLocationReferencePoint();
        Coordinates coord = this.createCoordinates(lrp);
        l.setCoordinates(coord);
        LineAttributes lineAttr = this.createLineAttr(lrp);
        l.setLineAttributes(lineAttr);
        PathAttributes pathAttr = this.createPathAttr(lrp);
        l.setPathAttributes(pathAttr);
        return l;
    }

    private PathAttributes createPathAttr(LocationReferencePoint lrp) {
        PathAttributes pathAttr = OBJECT_FACTORY.createPathAttributes();
        pathAttr.setDNP(BigInteger.valueOf(lrp.getDistanceToNext()));
        pathAttr.setLFRCNP(this.mapFRC(lrp.getLfrc()));
        return pathAttr;
    }

    protected final LineAttributes createLineAttr(LocationReferencePoint lrp) {
        LineAttributes lineAttr = OBJECT_FACTORY.createLineAttributes();
        int bearing = (int)Math.round(lrp.getBearing());
        if (bearing == 360) {
            bearing = 0;
        }
        lineAttr.setBEAR(bearing);
        lineAttr.setFOW(this.mapFOW(lrp.getFOW()));
        lineAttr.setFRC(this.mapFRC(lrp.getFRC()));
        return lineAttr;
    }

    private FRCType mapFRC(FunctionalRoadClass frc) {
        FRCType frcType = null;
        switch (frc) {
            case FRC_0: {
                frcType = FRCType.FRC_0;
                break;
            }
            case FRC_1: {
                frcType = FRCType.FRC_1;
                break;
            }
            case FRC_2: {
                frcType = FRCType.FRC_2;
                break;
            }
            case FRC_3: {
                frcType = FRCType.FRC_3;
                break;
            }
            case FRC_4: {
                frcType = FRCType.FRC_4;
                break;
            }
            case FRC_5: {
                frcType = FRCType.FRC_5;
                break;
            }
            case FRC_6: {
                frcType = FRCType.FRC_6;
                break;
            }
            case FRC_7: {
                frcType = FRCType.FRC_7;
                break;
            }
            default: {
                frcType = null;
            }
        }
        return frcType;
    }

    private FOWType mapFOW(FormOfWay fow) {
        FOWType fowType = null;
        switch (fow) {
            case MOTORWAY: {
                fowType = FOWType.MOTORWAY;
                break;
            }
            case MULTIPLE_CARRIAGEWAY: {
                fowType = FOWType.MULTIPLE_CARRIAGEWAY;
                break;
            }
            case OTHER: {
                fowType = FOWType.OTHER;
                break;
            }
            case ROUNDABOUT: {
                fowType = FOWType.ROUNDABOUT;
                break;
            }
            case SINGLE_CARRIAGEWAY: {
                fowType = FOWType.SINGLE_CARRIAGEWAY;
                break;
            }
            case SLIPROAD: {
                fowType = FOWType.SLIPROAD;
                break;
            }
            case TRAFFIC_SQUARE: {
                fowType = FOWType.TRAFFICSQUARE;
                break;
            }
            case UNDEFINED: {
                fowType = FOWType.UNDEFINED;
                break;
            }
            default: {
                fowType = null;
            }
        }
        return fowType;
    }

    protected final Coordinates createCoordinates(GeoCoordinates centerPoint) {
        Coordinates coord = OBJECT_FACTORY.createCoordinates();
        coord.setLongitude(centerPoint.getLongitudeDeg());
        coord.setLatitude(centerPoint.getLatitudeDeg());
        return coord;
    }

    protected final Coordinates createXMLCoordinates(GeoCoordinates centerPoint) {
        Coordinates coord = OBJECT_FACTORY.createCoordinates();
        coord.setLongitude(centerPoint.getLongitudeDeg());
        coord.setLatitude(centerPoint.getLatitudeDeg());
        return coord;
    }

    private Coordinates createCoordinates(LocationReferencePoint lrp) {
        Coordinates coord = OBJECT_FACTORY.createCoordinates();
        coord.setLatitude(lrp.getLatitudeDeg());
        coord.setLongitude(lrp.getLongitudeDeg());
        return coord;
    }

    protected final openlr.xml.generated.Offsets createOffsets(Offsets od, boolean negIncluded, int posDist, int negDist) {
        openlr.xml.generated.Offsets off = OBJECT_FACTORY.createOffsets();
        if (od.hasPositiveOffset()) {
            off.setPosOff(BigInteger.valueOf(od.getPositiveOffset(posDist)));
        } else {
            off.setPosOff(OpenLRXMLConstants.NO_OFFSET);
        }
        if (negIncluded && od.hasNegativeOffset()) {
            off.setNegOff(BigInteger.valueOf(od.getNegativeOffset(negDist)));
        } else {
            off.setNegOff(OpenLRXMLConstants.NO_OFFSET);
        }
        return off;
    }

    protected final OrientationType resolveOrientation(Orientation o) {
        OrientationType ot = null;
        switch (o) {
            case NO_ORIENTATION_OR_UNKNOWN: {
                ot = OrientationType.NO_ORIENTATION_OR_UNKNOWN;
                break;
            }
            case WITH_LINE_DIRECTION: {
                ot = OrientationType.WITH_LINE_DIRECTION;
                break;
            }
            case AGAINST_LINE_DIRECTION: {
                ot = OrientationType.AGAINST_LINE_DIRECTION;
                break;
            }
            case BOTH: {
                ot = OrientationType.BOTH;
                break;
            }
            default: {
                ot = OrientationType.NO_ORIENTATION_OR_UNKNOWN;
            }
        }
        return ot;
    }

    protected final SideOfRoadType resolveSideOfRoad(SideOfRoad s) {
        SideOfRoadType st = null;
        switch (s) {
            case ON_ROAD_OR_UNKNOWN: {
                st = SideOfRoadType.ON_ROAD_OR_UNKNOWN;
                break;
            }
            case RIGHT: {
                st = SideOfRoadType.RIGHT;
                break;
            }
            case LEFT: {
                st = SideOfRoadType.LEFT;
                break;
            }
            case BOTH: {
                st = SideOfRoadType.BOTH;
                break;
            }
            default: {
                st = SideOfRoadType.ON_ROAD_OR_UNKNOWN;
            }
        }
        return st;
    }
}

