/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.encoder;

import java.math.BigInteger;
import openlr.LocationReference;
import openlr.LocationType;
import openlr.map.GeoCoordinates;
import openlr.rawLocRef.RawLocationReference;
import openlr.xml.XmlReturnCode;
import openlr.xml.encoder.AbstractEncoder;
import openlr.xml.generated.AreaLocationReference;
import openlr.xml.generated.CircleLocationReference;
import openlr.xml.generated.GeoCoordinate;
import openlr.xml.generated.OpenLR;
import openlr.xml.generated.XMLLocationReference;
import openlr.xml.impl.LocationReferenceXmlImpl;

public class CircleEncoder
extends AbstractEncoder {
    @Override
    public final LocationReference encodeData(RawLocationReference rawLocRef, int version) {
        GeoCoordinates centerPoint = rawLocRef.getCenterPoint();
        long radius = rawLocRef.getRadius();
        if (centerPoint == null || radius < 0L) {
            return new LocationReferenceXmlImpl(rawLocRef.getID(), XmlReturnCode.INVALID_DATA, LocationType.CIRCLE, version);
        }
        OpenLR xmlData = OBJECT_FACTORY.createOpenLR();
        String id = "";
        if (rawLocRef.hasID()) {
            id = rawLocRef.getID();
        }
        xmlData.setLocationID(id);
        XMLLocationReference xmlLoc = this.createXMLCircleLocRef(centerPoint, radius);
        xmlData.setXMLLocationReference(xmlLoc);
        LocationReferenceXmlImpl locRefData = new LocationReferenceXmlImpl(id, xmlData, version);
        return locRefData;
    }

    private XMLLocationReference createXMLCircleLocRef(GeoCoordinates centerPoint, long radius) {
        XMLLocationReference xmlLoc = OBJECT_FACTORY.createXMLLocationReference();
        CircleLocationReference circleLocRef = this.createCircleLocRef(centerPoint, radius);
        AreaLocationReference areaLoc = OBJECT_FACTORY.createAreaLocationReference();
        areaLoc.setCircleLocationReference(circleLocRef);
        xmlLoc.setAreaLocationReference(areaLoc);
        return xmlLoc;
    }

    private CircleLocationReference createCircleLocRef(GeoCoordinates centerPoint, long radius) {
        CircleLocationReference circleLocRef = OBJECT_FACTORY.createCircleLocationReference();
        circleLocRef.setRadius(BigInteger.valueOf(radius));
        GeoCoordinate gc = OBJECT_FACTORY.createGeoCoordinate();
        gc.setCoordinates(this.createCoordinates(centerPoint));
        circleLocRef.setGeoCoordinate(gc);
        return circleLocRef;
    }
}

