/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.encoder;

import java.util.List;
import openlr.LocationReference;
import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.rawLocRef.RawLocationReference;
import openlr.xml.XmlReturnCode;
import openlr.xml.encoder.AbstractEncoder;
import openlr.xml.generated.AreaLocationReference;
import openlr.xml.generated.ClosedLineLocationReference;
import openlr.xml.generated.LineAttributes;
import openlr.xml.generated.OpenLR;
import openlr.xml.generated.XMLLocationReference;
import openlr.xml.impl.LocationReferenceXmlImpl;

public class ClosedLineEncoder
extends AbstractEncoder {
    @Override
    public final LocationReference encodeData(RawLocationReference rawLocRef, int version) {
        List locRef = rawLocRef.getLocationReferencePoints();
        if (locRef == null) {
            return new LocationReferenceXmlImpl(rawLocRef.getID(), XmlReturnCode.INVALID_DATA, LocationType.CLOSED_LINE, version);
        }
        OpenLR xmlData = OBJECT_FACTORY.createOpenLR();
        String id = "";
        if (rawLocRef.hasID()) {
            id = rawLocRef.getID();
        }
        xmlData.setLocationID(id);
        XMLLocationReference xmlLoc = this.createXMLClosedLineLocRef(locRef);
        xmlData.setXMLLocationReference(xmlLoc);
        LocationReferenceXmlImpl locRefData = new LocationReferenceXmlImpl(id, xmlData, version);
        return locRefData;
    }

    private XMLLocationReference createXMLClosedLineLocRef(List<? extends LocationReferencePoint> locRef) {
        XMLLocationReference xmlLoc = OBJECT_FACTORY.createXMLLocationReference();
        ClosedLineLocationReference closedLineLocRef = this.createClosedLineLocRef(locRef);
        AreaLocationReference areaLoc = OBJECT_FACTORY.createAreaLocationReference();
        areaLoc.setClosedLineLocationReference(closedLineLocRef);
        xmlLoc.setAreaLocationReference(areaLoc);
        return xmlLoc;
    }

    private ClosedLineLocationReference createClosedLineLocRef(List<? extends LocationReferencePoint> locRef) {
        ClosedLineLocationReference closedLineLocRef = OBJECT_FACTORY.createClosedLineLocationReference();
        List<openlr.xml.generated.LocationReferencePoint> lrps = this.createClosedLineLRPs(locRef);
        closedLineLocRef.getLocationReferencePoint().addAll(lrps);
        LocationReferencePoint lastLine = locRef.get(locRef.size() - 1);
        LineAttributes lineAttr = this.createLineAttr(lastLine);
        closedLineLocRef.setLastLine(lineAttr);
        return closedLineLocRef;
    }
}

