/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.encoder;

import openlr.LocationReference;
import openlr.map.GeoCoordinates;
import openlr.rawLocRef.RawLocationReference;
import openlr.xml.encoder.AbstractEncoder;
import openlr.xml.generated.Coordinates;
import openlr.xml.generated.GeoCoordinate;
import openlr.xml.generated.OpenLR;
import openlr.xml.generated.PointLocationReference;
import openlr.xml.generated.XMLLocationReference;
import openlr.xml.impl.LocationReferenceXmlImpl;

public class GeoCoordEncoder
extends AbstractEncoder {
    private XMLLocationReference createXMLGeoCoordLocRef(GeoCoordinates gCoord) {
        XMLLocationReference xmlLoc = OBJECT_FACTORY.createXMLLocationReference();
        PointLocationReference pointLoc = OBJECT_FACTORY.createPointLocationReference();
        GeoCoordinate geoCoord = OBJECT_FACTORY.createGeoCoordinate();
        Coordinates coord = OBJECT_FACTORY.createCoordinates();
        coord.setLongitude(gCoord.getLongitudeDeg());
        coord.setLatitude(gCoord.getLatitudeDeg());
        geoCoord.setCoordinates(coord);
        pointLoc.setGeoCoordinate(geoCoord);
        xmlLoc.setPointLocationReference(pointLoc);
        return xmlLoc;
    }

    @Override
    public final LocationReference encodeData(RawLocationReference rawLocRef, int version) {
        GeoCoordinates coord = rawLocRef.getGeoCoordinates();
        OpenLR xmlData = OBJECT_FACTORY.createOpenLR();
        String id = "";
        if (rawLocRef.hasID()) {
            id = rawLocRef.getID();
        }
        xmlData.setLocationID(id);
        XMLLocationReference xmlLoc = this.createXMLGeoCoordLocRef(coord);
        xmlData.setXMLLocationReference(xmlLoc);
        LocationReferenceXmlImpl locRefData = new LocationReferenceXmlImpl(id, xmlData, version);
        return locRefData;
    }
}

