/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.encoder;

import openlr.LocationReference;
import openlr.LocationType;
import openlr.map.GeoCoordinates;
import openlr.rawLocRef.RawLocationReference;
import openlr.xml.XmlReturnCode;
import openlr.xml.encoder.AbstractEncoder;
import openlr.xml.generated.AreaLocationReference;
import openlr.xml.generated.GridLocationReference;
import openlr.xml.generated.OpenLR;
import openlr.xml.generated.Rectangle;
import openlr.xml.generated.XMLLocationReference;
import openlr.xml.impl.LocationReferenceXmlImpl;

public class GridEncoder
extends AbstractEncoder {
    @Override
    public final LocationReference encodeData(RawLocationReference rawLocRef, int version) {
        GeoCoordinates lowerLeftPoint = rawLocRef.getLowerLeftPoint();
        GeoCoordinates upperRightPoint = rawLocRef.getUpperRightPoint();
        int ncols = rawLocRef.getNumberOfColumns();
        int nrows = rawLocRef.getNumberOfRows();
        if (lowerLeftPoint == null || upperRightPoint == null) {
            return new LocationReferenceXmlImpl(rawLocRef.getID(), XmlReturnCode.INVALID_DATA, LocationType.GRID, version);
        }
        OpenLR xmlData = OBJECT_FACTORY.createOpenLR();
        String id = "";
        if (rawLocRef.hasID()) {
            id = rawLocRef.getID();
        }
        xmlData.setLocationID(id);
        XMLLocationReference xmlLoc = this.createXMLGridLocRef(lowerLeftPoint, upperRightPoint, ncols, nrows);
        xmlData.setXMLLocationReference(xmlLoc);
        LocationReferenceXmlImpl locRefData = new LocationReferenceXmlImpl(id, xmlData, version);
        return locRefData;
    }

    private XMLLocationReference createXMLGridLocRef(GeoCoordinates lowerLeftPoint, GeoCoordinates upperRightPoint, int ncols, int nrows) {
        XMLLocationReference xmlLoc = OBJECT_FACTORY.createXMLLocationReference();
        GridLocationReference gridLocRef = this.createGridLocRef(lowerLeftPoint, upperRightPoint, ncols, nrows);
        AreaLocationReference areaLoc = OBJECT_FACTORY.createAreaLocationReference();
        areaLoc.setGridLocationReference(gridLocRef);
        xmlLoc.setAreaLocationReference(areaLoc);
        return xmlLoc;
    }

    private GridLocationReference createGridLocRef(GeoCoordinates lowerLeftPoint, GeoCoordinates upperRightPoint, int ncols, int nrows) {
        GridLocationReference gridLocRef = OBJECT_FACTORY.createGridLocationReference();
        Rectangle rect = OBJECT_FACTORY.createRectangle();
        rect.setLowerLeft(this.createXMLCoordinates(lowerLeftPoint));
        rect.setUpperRight(this.createXMLCoordinates(upperRightPoint));
        gridLocRef.setRectangle(rect);
        gridLocRef.setNumColumns((short)ncols);
        gridLocRef.setNumRows((short)nrows);
        return gridLocRef;
    }
}

