/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.encoder;

import java.util.List;
import openlr.LocationReference;
import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.Offsets;
import openlr.rawLocRef.RawLocationReference;
import openlr.xml.XmlReturnCode;
import openlr.xml.encoder.AbstractEncoder;
import openlr.xml.generated.LastLocationReferencePoint;
import openlr.xml.generated.LineLocationReference;
import openlr.xml.generated.OpenLR;
import openlr.xml.generated.XMLLocationReference;
import openlr.xml.impl.LocationReferenceXmlImpl;

public class LineEncoder
extends AbstractEncoder {
    @Override
    public final LocationReference encodeData(RawLocationReference rawLocRef, int version) {
        List locRef = rawLocRef.getLocationReferencePoints();
        Offsets od = rawLocRef.getOffsets();
        if (locRef == null || od == null) {
            return new LocationReferenceXmlImpl(rawLocRef.getID(), XmlReturnCode.INVALID_DATA, LocationType.LINE_LOCATION, version);
        }
        OpenLR xmlData = OBJECT_FACTORY.createOpenLR();
        String id = "";
        if (rawLocRef.hasID()) {
            id = rawLocRef.getID();
        }
        xmlData.setLocationID(id);
        XMLLocationReference xmlLoc = this.createXMLLineLocRef(locRef, od);
        xmlData.setXMLLocationReference(xmlLoc);
        LocationReferenceXmlImpl locRefData = new LocationReferenceXmlImpl(id, xmlData, version);
        return locRefData;
    }

    private XMLLocationReference createXMLLineLocRef(List<? extends LocationReferencePoint> locRef, Offsets od) {
        XMLLocationReference xmlLoc = OBJECT_FACTORY.createXMLLocationReference();
        LineLocationReference lineLocRef = this.createLineLocRef(locRef, od);
        xmlLoc.setLineLocationReference(lineLocRef);
        return xmlLoc;
    }

    private LineLocationReference createLineLocRef(List<? extends LocationReferencePoint> locRef, Offsets od) {
        LineLocationReference lineLocRef = OBJECT_FACTORY.createLineLocationReference();
        int posDist = locRef.get(0).getDistanceToNext();
        int negDist = locRef.get(locRef.size() - 2).getDistanceToNext();
        openlr.xml.generated.Offsets o = this.createOffsets(od, true, posDist, negDist);
        lineLocRef.setOffsets(o);
        List<openlr.xml.generated.LocationReferencePoint> lrps = this.createLRPs(locRef);
        lineLocRef.getLocationReferencePoint().addAll(lrps);
        LastLocationReferencePoint llrp = this.createLastLRP(locRef);
        lineLocRef.setLastLocationReferencePoint(llrp);
        return lineLocRef;
    }
}

