/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.encoder;

import java.util.ArrayList;
import openlr.LocationReference;
import openlr.LocationReferencePoint;
import openlr.Offsets;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.rawLocRef.RawLocationReference;
import openlr.xml.encoder.AbstractEncoder;
import openlr.xml.generated.LastLocationReferencePoint;
import openlr.xml.generated.OpenLR;
import openlr.xml.generated.PointAlongLine;
import openlr.xml.generated.PointLocationReference;
import openlr.xml.generated.XMLLocationReference;
import openlr.xml.impl.LocationReferenceXmlImpl;

public class PointAlongEncoder
extends AbstractEncoder {
    @Override
    public final LocationReference encodeData(RawLocationReference rawLocRef, int version) {
        LocationReferencePoint startLRP = (LocationReferencePoint)rawLocRef.getLocationReferencePoints().get(0);
        LocationReferencePoint endLRP = (LocationReferencePoint)rawLocRef.getLocationReferencePoints().get(1);
        Offsets od = rawLocRef.getOffsets();
        SideOfRoad s = rawLocRef.getSideOfRoad();
        Orientation o = rawLocRef.getOrientation();
        OpenLR xmlData = OBJECT_FACTORY.createOpenLR();
        String id = "";
        if (rawLocRef.hasID()) {
            id = rawLocRef.getID();
        }
        xmlData.setLocationID(id);
        XMLLocationReference xmlLoc = this.createXMLPointAlongLineLocRef(startLRP, endLRP, od, s, o);
        xmlData.setXMLLocationReference(xmlLoc);
        LocationReferenceXmlImpl locRefData = new LocationReferenceXmlImpl(id, xmlData, version);
        return locRefData;
    }

    private XMLLocationReference createXMLPointAlongLineLocRef(LocationReferencePoint startLRP, LocationReferencePoint endLRP, Offsets od, SideOfRoad s, Orientation o) {
        XMLLocationReference xmlLoc = OBJECT_FACTORY.createXMLLocationReference();
        PointLocationReference pointLoc = OBJECT_FACTORY.createPointLocationReference();
        PointAlongLine pal = OBJECT_FACTORY.createPointAlongLine();
        openlr.xml.generated.LocationReferencePoint lrp1 = this.createLRP(startLRP);
        ArrayList<LocationReferencePoint> lrps = new ArrayList<LocationReferencePoint>();
        lrps.add(startLRP);
        lrps.add(endLRP);
        LastLocationReferencePoint lrp2 = this.createLastLRP(lrps);
        openlr.xml.generated.Offsets off = this.createOffsets(od, false, startLRP.getDistanceToNext(), 0);
        pal.setLocationReferencePoint(lrp1);
        pal.setLastLocationReferencePoint(lrp2);
        pal.setOffsets(off);
        pal.setSideOfRoad(this.resolveSideOfRoad(s));
        pal.setOrientation(this.resolveOrientation(o));
        pointLoc.setPointAlongLine(pal);
        xmlLoc.setPointLocationReference(pointLoc);
        return xmlLoc;
    }
}

