/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.encoder;

import java.util.List;
import openlr.LocationReference;
import openlr.LocationType;
import openlr.map.GeoCoordinates;
import openlr.rawLocRef.RawLocationReference;
import openlr.xml.XmlReturnCode;
import openlr.xml.encoder.AbstractEncoder;
import openlr.xml.generated.AreaLocationReference;
import openlr.xml.generated.Coordinates;
import openlr.xml.generated.OpenLR;
import openlr.xml.generated.PolygonLocationReference;
import openlr.xml.generated.XMLLocationReference;
import openlr.xml.impl.LocationReferenceXmlImpl;

public class PolygonEncoder
extends AbstractEncoder {
    @Override
    public final LocationReference encodeData(RawLocationReference rawLocRef, int version) {
        List cornerPoints = rawLocRef.getCornerPoints();
        if (cornerPoints == null) {
            return new LocationReferenceXmlImpl(rawLocRef.getID(), XmlReturnCode.INVALID_DATA, LocationType.POLYGON, version);
        }
        OpenLR xmlData = OBJECT_FACTORY.createOpenLR();
        String id = "";
        if (rawLocRef.hasID()) {
            id = rawLocRef.getID();
        }
        xmlData.setLocationID(id);
        XMLLocationReference xmlLoc = this.createXMLPolygonLocRef(cornerPoints);
        xmlData.setXMLLocationReference(xmlLoc);
        LocationReferenceXmlImpl locRefData = new LocationReferenceXmlImpl(id, xmlData, version);
        return locRefData;
    }

    private XMLLocationReference createXMLPolygonLocRef(List<? extends GeoCoordinates> cornerPoints) {
        XMLLocationReference xmlLoc = OBJECT_FACTORY.createXMLLocationReference();
        PolygonLocationReference polygonLocRef = this.createPolygonLocRef(cornerPoints);
        AreaLocationReference areaLoc = OBJECT_FACTORY.createAreaLocationReference();
        areaLoc.setPolygonLocationReference(polygonLocRef);
        xmlLoc.setAreaLocationReference(areaLoc);
        return xmlLoc;
    }

    private PolygonLocationReference createPolygonLocRef(List<? extends GeoCoordinates> cornerPoints) {
        PolygonLocationReference polygonLocRef = OBJECT_FACTORY.createPolygonLocationReference();
        PolygonLocationReference.PolygonCorners pCorners = OBJECT_FACTORY.createPolygonLocationReferencePolygonCorners();
        polygonLocRef.setPolygonCorners(pCorners);
        List<Coordinates> corners = pCorners.getCoordinates();
        corners.clear();
        for (GeoCoordinates geoCoordinates : cornerPoints) {
            corners.add(this.createCoordinates(geoCoordinates));
        }
        return polygonLocRef;
    }
}

