/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.encoder;

import openlr.LocationReference;
import openlr.LocationType;
import openlr.map.GeoCoordinates;
import openlr.rawLocRef.RawLocationReference;
import openlr.xml.XmlReturnCode;
import openlr.xml.encoder.AbstractEncoder;
import openlr.xml.generated.AreaLocationReference;
import openlr.xml.generated.OpenLR;
import openlr.xml.generated.Rectangle;
import openlr.xml.generated.RectangleLocationReference;
import openlr.xml.generated.XMLLocationReference;
import openlr.xml.impl.LocationReferenceXmlImpl;

public class RectangleEncoder
extends AbstractEncoder {
    @Override
    public final LocationReference encodeData(RawLocationReference rawLocRef, int version) {
        GeoCoordinates lowerLeftPoint = rawLocRef.getLowerLeftPoint();
        GeoCoordinates upperRightPoint = rawLocRef.getUpperRightPoint();
        if (lowerLeftPoint == null || upperRightPoint == null) {
            return new LocationReferenceXmlImpl(rawLocRef.getID(), XmlReturnCode.INVALID_DATA, LocationType.RECTANGLE, version);
        }
        OpenLR xmlData = OBJECT_FACTORY.createOpenLR();
        String id = "";
        if (rawLocRef.hasID()) {
            id = rawLocRef.getID();
        }
        xmlData.setLocationID(id);
        XMLLocationReference xmlLoc = this.createXMLRectangleLocRef(lowerLeftPoint, upperRightPoint);
        xmlData.setXMLLocationReference(xmlLoc);
        LocationReferenceXmlImpl locRefData = new LocationReferenceXmlImpl(id, xmlData, version);
        return locRefData;
    }

    private XMLLocationReference createXMLRectangleLocRef(GeoCoordinates leftmostPoint, GeoCoordinates rightmostPoint) {
        XMLLocationReference xmlLoc = OBJECT_FACTORY.createXMLLocationReference();
        RectangleLocationReference rectangleLocRef = this.createRectangleLocRef(leftmostPoint, rightmostPoint);
        AreaLocationReference areaLoc = OBJECT_FACTORY.createAreaLocationReference();
        areaLoc.setRectangleLocationReference(rectangleLocRef);
        xmlLoc.setAreaLocationReference(areaLoc);
        return xmlLoc;
    }

    private RectangleLocationReference createRectangleLocRef(GeoCoordinates leftmostPoint, GeoCoordinates rightmostPoint) {
        RectangleLocationReference rectangleLocRef = OBJECT_FACTORY.createRectangleLocationReference();
        Rectangle rect = OBJECT_FACTORY.createRectangle();
        rect.setLowerLeft(this.createXMLCoordinates(leftmostPoint));
        rect.setUpperRight(this.createXMLCoordinates(rightmostPoint));
        rectangleLocRef.setRectangle(rect);
        return rectangleLocRef;
    }
}

