/*
 * Decompiled with CFR 0.152.
 */
package openlr.xml.impl;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBException;
import openlr.LocationReference;
import openlr.LocationType;
import openlr.StatusCode;
import openlr.xml.LocationReferenceXmlHelper;
import openlr.xml.OpenLRXmlWriter;
import openlr.xml.XmlReturnCode;
import openlr.xml.generated.OpenLR;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.xml.sax.SAXException;

public class LocationReferenceXmlImpl
implements LocationReference {
    private final String id;
    private final XmlReturnCode returnCode;
    private final LocationType locType;
    private final OpenLR data;
    private final int version;

    public LocationReferenceXmlImpl(String i, OpenLR d, int ver) {
        this.id = i;
        this.data = d;
        this.returnCode = null;
        this.locType = LocationReferenceXmlHelper.resolveLocationType(d);
        this.version = ver;
    }

    public LocationReferenceXmlImpl(String i, XmlReturnCode e, LocationType t, int ver) {
        this.id = i;
        this.data = null;
        this.returnCode = e;
        this.locType = t;
        this.version = ver;
    }

    public final StatusCode getReturnCode() {
        return this.returnCode;
    }

    public final String getID() {
        return this.id;
    }

    public final boolean isValid() {
        return this.returnCode == null && this.locType != LocationType.UNKNOWN;
    }

    public final Class<?> getDataClass() {
        return OpenLR.class;
    }

    public final String getDataIdentifier() {
        return "xml";
    }

    public final Object getLocationReferenceData() {
        if (this.isValid()) {
            return this.data;
        }
        return null;
    }

    public final void toStream(OutputStream os) throws IOException {
        OpenLRXmlWriter writer = null;
        try {
            writer = new OpenLRXmlWriter();
            writer.saveOpenLRXML(this.data, os, true);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public final LocationType getLocationType() {
        return this.locType;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.id);
        sb.append(" type: ").append(this.locType);
        if (this.returnCode != null) {
            sb.append(" error: ").append((Object)this.returnCode);
        } else {
            sb.append(" data: ").append(this.data);
        }
        return sb.toString();
    }

    public final int getVersion() {
        return this.version;
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.locType).append((Object)this.returnCode).append((Object)this.data).append(this.version);
        return builder.toHashCode();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof LocationReferenceXmlImpl)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        LocationReferenceXmlImpl other = (LocationReferenceXmlImpl)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.locType, (Object)other.locType).append((Object)this.returnCode, (Object)other.returnCode).append((Object)this.data, (Object)other.data).append(this.version, other.version);
        return builder.isEquals();
    }
}

