/*
 * Decompiled with CFR 0.152.
 */
package openlr.map;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public enum FunctionalRoadClass {
    FRC_0(0),
    FRC_1(1),
    FRC_2(2),
    FRC_3(3),
    FRC_4(4),
    FRC_5(5),
    FRC_6(6),
    FRC_7(7);

    private int uid;
    private static final List<FunctionalRoadClass> VALUES;

    private FunctionalRoadClass(int id) {
        this.uid = id;
    }

    public int getID() {
        return this.uid;
    }

    public FunctionalRoadClass lower() {
        int temp = this.uid + 1;
        if (temp >= VALUES.size()) {
            temp = VALUES.size() - 1;
        }
        return VALUES.get(temp);
    }

    public FunctionalRoadClass higher() {
        int temp = this.uid - 1;
        if (temp < 0) {
            temp = 0;
        }
        return VALUES.get(temp);
    }

    public static List<FunctionalRoadClass> getFRCs() {
        return VALUES;
    }

    public static FunctionalRoadClass getHighestFrc() {
        return FRC_0;
    }

    public static FunctionalRoadClass getLowestFrc() {
        return FRC_7;
    }

    static {
        VALUES = Collections.unmodifiableList(Arrays.asList(FunctionalRoadClass.values()));
    }

    public static final class FrcComparator
    implements Comparator<FunctionalRoadClass>,
    Serializable {
        private static final long serialVersionUID = -1253845002995317959L;

        @Override
        public int compare(FunctionalRoadClass o1, FunctionalRoadClass o2) {
            if (o1.getID() < o2.getID()) {
                return 1;
            }
            if (o1.getID() > o2.getID()) {
                return -1;
            }
            return 0;
        }
    }
}

