/*
 * Decompiled with CFR 0.152.
 */
package openlr.map;

import openlr.map.GeoCoordinates;
import openlr.map.InvalidMapDataException;
import openlr.map.utils.GeometryUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class GeoCoordinatesImpl
implements GeoCoordinates {
    private final double longitude;
    private final double latitude;

    public GeoCoordinatesImpl(double lon, double lat) throws InvalidMapDataException {
        if (!GeometryUtils.checkCoordinateBounds(lon, lat)) {
            throw new InvalidMapDataException("Coordinates out of bounds!");
        }
        this.longitude = lon;
        this.latitude = lat;
    }

    public static final GeoCoordinatesImpl newGeoCoordinatesUnchecked(double lon, double lat) {
        try {
            return new GeoCoordinatesImpl(lon, lat);
        }
        catch (InvalidMapDataException e) {
            throw new IllegalArgumentException("Illegal coordinates provided for instantiation of GeoCoordinateImpl: " + lon + ", " + lat + " (long, lat)");
        }
    }

    @Override
    public final double getLatitudeDeg() {
        return this.latitude;
    }

    @Override
    public final double getLongitudeDeg() {
        return this.longitude;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("lon: ").append(this.longitude);
        sb.append(" lat: ").append(this.latitude);
        return sb.toString();
    }

    @Override
    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.latitude).append(this.longitude);
        return builder.toHashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof GeoCoordinatesImpl)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoCoordinatesImpl other = (GeoCoordinatesImpl)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.latitude, other.latitude).append(this.longitude, other.longitude);
        return builder.isEquals();
    }
}

