/*
 * Decompiled with CFR 0.152.
 */
package openlr.map;

import java.util.ArrayList;
import java.util.List;
import openlr.map.GeoCoordinates;
import openlr.map.InvalidMapDataException;
import openlr.map.utils.GeometryUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RectangleCorners {
    private static final double ZERO_CIRCLE = 0.0;
    private static final double HALF_CIRCLE = 180.0;
    private static final double QUARTER_CIRCLE = 90.0;
    private static final double THREE_QUARTER_CIRCLE = 270.0;
    private final GeoCoordinates lowerLeft;
    private final GeoCoordinates lowerRight;
    private final GeoCoordinates upperLeft;
    private final GeoCoordinates upperRight;

    public RectangleCorners(GeoCoordinates ll, GeoCoordinates ur) throws InvalidMapDataException {
        if (!GeometryUtils.checkCoordinateBounds(ll.getLongitudeDeg(), ll.getLatitudeDeg())) {
            throw new InvalidMapDataException("rectangle lower left coordinates are invalid");
        }
        if (!GeometryUtils.checkCoordinateBounds(ur.getLongitudeDeg(), ur.getLatitudeDeg())) {
            throw new InvalidMapDataException("rectangle upper right coordinates are invalid");
        }
        this.lowerLeft = ll;
        this.upperRight = ur;
        if (ll.getLongitudeDeg() > ur.getLongitudeDeg() || ll.getLatitudeDeg() > ur.getLatitudeDeg()) {
            throw new InvalidMapDataException("rectangle coordinates are invalid");
        }
        this.upperLeft = GeometryUtils.intersectStraights(ll.getLongitudeDeg(), ll.getLatitudeDeg(), 0.0, ur.getLongitudeDeg(), ur.getLatitudeDeg(), 270.0);
        this.lowerRight = GeometryUtils.intersectStraights(ll.getLongitudeDeg(), ll.getLatitudeDeg(), 90.0, ur.getLongitudeDeg(), ur.getLatitudeDeg(), 180.0);
    }

    public RectangleCorners(GeoCoordinates ll, GeoCoordinates ur, GeoCoordinates lr, GeoCoordinates ul) throws InvalidMapDataException {
        if (ll.getLongitudeDeg() > ur.getLongitudeDeg() || ll.getLatitudeDeg() > ur.getLatitudeDeg()) {
            throw new InvalidMapDataException("rectangle coordinates are invalid");
        }
        this.lowerLeft = ll;
        this.upperRight = ur;
        this.upperLeft = ul;
        this.lowerRight = lr;
    }

    public final GeoCoordinates getLowerLeft() {
        return this.lowerLeft;
    }

    public final GeoCoordinates getLowerRight() {
        return this.lowerRight;
    }

    public final GeoCoordinates getUpperLeft() {
        return this.upperLeft;
    }

    public final GeoCoordinates getUpperRight() {
        return this.upperRight;
    }

    public final List<GeoCoordinates> getCornerPoints() {
        ArrayList<GeoCoordinates> coords = new ArrayList<GeoCoordinates>();
        coords.add(this.lowerLeft);
        coords.add(this.lowerRight);
        coords.add(this.upperRight);
        coords.add(this.upperLeft);
        return coords;
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.lowerLeft).append((Object)this.lowerRight).append((Object)this.upperLeft).append((Object)this.upperRight);
        return builder.toHashCode();
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RectangleCorners)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        RectangleCorners other = (RectangleCorners)o;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.lowerLeft, (Object)other.lowerLeft).append((Object)this.lowerRight, (Object)other.lowerRight).append((Object)this.upperLeft, (Object)other.upperLeft).append((Object)this.upperLeft, (Object)other.upperLeft);
        return builder.isEquals();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("lower left: ").append(this.lowerLeft).append("\n");
        sb.append("lower right: ").append(this.lowerRight).append("\n");
        sb.append("upper right: ").append(this.upperRight).append("\n");
        sb.append("upper left: ").append(this.upperLeft).append("\n");
        return sb.toString();
    }
}

