/*
 * Decompiled with CFR 0.152.
 */
package openlr.map.utils;

import java.awt.geom.Line2D;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.Line;

public final class GeometryUtils {
    public static final float MAX_LAT = 90.0f;
    public static final float MIN_LAT = -90.0f;
    public static final float MAX_LON = 180.0f;
    public static final float MIN_LON = -180.0f;
    public static final double ZERO_CIRCLE = 0.0;
    public static final double HALF_CIRCLE = 180.0;
    public static final double QUARTER_CIRCLE = 90.0;
    public static final double THREE_QUARTER_CIRCLE = 270.0;
    private static final int DEFAULT_PRECISION = 5;
    private static final int TEN = 10;
    private static final int THREE = 3;
    private static final float METER_PER_KILOMETER = 1000.0f;
    private static final int DIVISIONS_PER_DEGREE = 100000;
    public static final int FULL_CIRCLE_DEGREE = 360;
    private static final double RAD_FACTOR = Math.PI / 180;
    private static final double EQUATORIAL_RADIUS = 6378137.0;
    private static final double INVERSE_FLATTENING = 298.257223563;
    private static final double OBLATENESS = 0.0033528106647474805;

    private GeometryUtils() {
        throw new UnsupportedOperationException();
    }

    private static double toRadians(double value) {
        return value * (Math.PI / 180);
    }

    public static double distance(GeoCoordinates coord1, GeoCoordinates coord2) {
        return GeometryUtils.distance(coord1.getLongitudeDeg(), coord1.getLatitudeDeg(), coord2.getLongitudeDeg(), coord2.getLatitudeDeg());
    }

    public static double distance(double longitude1, double latitude1, double longitude2, double latitude2) {
        if (latitude2 == latitude1 && longitude2 == longitude1) {
            return 0.0;
        }
        double f = GeometryUtils.toRadians((latitude2 + latitude1) / 2.0);
        double g = GeometryUtils.toRadians((latitude2 - latitude1) / 2.0);
        double l = GeometryUtils.toRadians((longitude2 - longitude1) / 2.0);
        double sinF = Math.sin(f);
        double sinG = Math.sin(g);
        double cosF = Math.cos(f);
        double cosG = Math.cos(g);
        double sinl = Math.sin(l);
        double cosl = Math.cos(l);
        double s = sinG * sinG * cosl * cosl + cosF * cosF * sinl * sinl;
        if (s == 0.0) {
            return 0.0;
        }
        double c = cosG * cosG * cosl * cosl + sinF * sinF * sinl * sinl;
        if (c == 0.0) {
            return 0.0;
        }
        double w = Math.atan(Math.sqrt(s / c));
        if (w == 0.0) {
            return 0.0;
        }
        double d = 2.0 * w * 6378137.0;
        double r = Math.sqrt(s * c) / w;
        double h1 = (3.0 * r - 1.0) / (2.0 * c);
        double h2 = (3.0 * r + 1.0) / (2.0 * s);
        return d * (1.0 + 0.0033528106647474805 * h1 * sinF * sinF * cosG * cosG - 0.0033528106647474805 * h2 * cosF * cosF * sinG * sinG);
    }

    private static double transformDecaMicroDeg(double val) {
        return val * 100000.0;
    }

    public static double bearing(GeoCoordinates coord1, GeoCoordinates coord2) {
        return GeometryUtils.bearing(coord1.getLongitudeDeg(), coord1.getLatitudeDeg(), coord2.getLongitudeDeg(), coord2.getLatitudeDeg());
    }

    public static double bearing(double p1Longitude, double p1Latitude, double p2Longitude, double p2Latitude) {
        double deltaY;
        double deltaX = GeometryUtils.transformDecaMicroDeg(p2Longitude - p1Longitude) * GeometryUtils.hMult(p2Latitude);
        double angle = Math.toDegrees(Math.atan2(deltaX, deltaY = GeometryUtils.transformDecaMicroDeg(p2Latitude - p1Latitude)));
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    private static double hMult(double y) {
        return Math.cos(y * (Math.PI / 180));
    }

    public static double calculateLineBearing(Line line, BearingDirection dir, int pointDistance, int projectionAlongLine) {
        if (line == null) {
            return -1.0;
        }
        GeoCoordinates p1 = null;
        GeoCoordinates p2 = null;
        if (dir == BearingDirection.IN_DIRECTION) {
            if (projectionAlongLine > 0) {
                p1 = line.getGeoCoordinateAlongLine(projectionAlongLine);
                p2 = line.getLineLength() < projectionAlongLine + pointDistance ? line.getEndNode().getGeoCoordinates() : line.getGeoCoordinateAlongLine(projectionAlongLine + pointDistance);
            } else {
                p1 = line.getStartNode().getGeoCoordinates();
                p2 = line.getLineLength() < pointDistance ? line.getEndNode().getGeoCoordinates() : line.getGeoCoordinateAlongLine(pointDistance);
            }
        } else if (projectionAlongLine > 0) {
            p1 = line.getGeoCoordinateAlongLine(projectionAlongLine);
            p2 = projectionAlongLine < pointDistance ? line.getStartNode().getGeoCoordinates() : line.getGeoCoordinateAlongLine(projectionAlongLine - pointDistance);
        } else {
            p1 = line.getEndNode().getGeoCoordinates();
            p2 = line.getLineLength() < pointDistance ? line.getStartNode().getGeoCoordinates() : line.getGeoCoordinateAlongLine(line.getLineLength() - pointDistance);
        }
        return GeometryUtils.bearing(p1, p2);
    }

    public static boolean checkCoordinateBounds(double lon, double lat) {
        return lon >= -180.0 && lon <= 180.0 && lat >= -90.0 && lat <= 90.0;
    }

    public static GeoCoordinates intersectStraights(GeoCoordinates coord1, double bear1, GeoCoordinates coord2, double bear2) throws InvalidMapDataException {
        return GeometryUtils.intersectStraights(coord1.getLongitudeDeg(), coord1.getLatitudeDeg(), bear1, coord2.getLongitudeDeg(), coord2.getLatitudeDeg(), bear2);
    }

    public static GeoCoordinates intersectStraights(double longitude1, double latitude1, double bear1, double longitude2, double latitude2, double bear2) throws InvalidMapDataException {
        double m1 = Math.tan(GeometryUtils.toRadians(90.0 - bear1));
        double m2 = Math.tan(GeometryUtils.toRadians(90.0 - bear2));
        if (bear1 == 0.0) {
            if (bear2 == 0.0) {
                return null;
            }
            double x = longitude1;
            double y = m2 * (x - longitude2) + latitude2;
            if (Double.isInfinite(x) || Double.isInfinite(y)) {
                return null;
            }
            return new GeoCoordinatesImpl(x, y);
        }
        if (bear2 == 0.0) {
            if (bear1 == 0.0) {
                return null;
            }
            double x = longitude2;
            double y = m1 * (x - longitude1) + latitude1;
            if (Double.isInfinite(x) || Double.isInfinite(y)) {
                return null;
            }
            return new GeoCoordinatesImpl(x, y);
        }
        if (Double.isNaN(m1) || Double.isInfinite(m1) || Double.isNaN(m2) || Double.isInfinite(m2)) {
            return null;
        }
        if (m1 == m2) {
            return null;
        }
        double x = (m1 * longitude1 - m2 * longitude2 + latitude2 - latitude1) / (m1 - m2);
        double y = latitude1 + m1 * (x - longitude1);
        if (Double.isInfinite(x) || Double.isInfinite(y)) {
            return null;
        }
        return new GeoCoordinatesImpl(x, y);
    }

    public static boolean lineIntersection(GeoCoordinates gc1Start, GeoCoordinates gc1End, GeoCoordinates gc2Start, GeoCoordinates gc2End) {
        Line2D.Double line1 = new Line2D.Double(gc1Start.getLongitudeDeg(), gc1Start.getLatitudeDeg(), gc1End.getLongitudeDeg(), gc1End.getLatitudeDeg());
        Line2D.Double line2 = new Line2D.Double(gc2Start.getLongitudeDeg(), gc2Start.getLatitudeDeg(), gc2End.getLongitudeDeg(), gc2End.getLatitudeDeg());
        return line1.intersectsLine(line2);
    }

    public static GeoCoordinates pointAlongLine(GeoCoordinates coord1, GeoCoordinates coord2, double offset) throws InvalidMapDataException {
        return GeometryUtils.pointAlongLine(coord1.getLongitudeDeg(), coord1.getLatitudeDeg(), coord2.getLongitudeDeg(), coord2.getLatitudeDeg(), offset);
    }

    public static GeoCoordinates pointAlongLine(double longitudeA, double latitudeA, double longitudeB, double latitudeB, double offset) throws InvalidMapDataException {
        double deltaX = Math.abs(longitudeB - longitudeA);
        double deltaY = latitudeB - latitudeA;
        if (longitudeA > longitudeB) {
            deltaX = -deltaX;
        }
        if (latitudeA < latitudeB) {
            if (deltaY < 0.0) {
                deltaY = -deltaY;
            }
        } else if (deltaY > 0.0) {
            deltaY = -deltaY;
        }
        double lon = longitudeA + (deltaX *= offset);
        double lat = latitudeA + (deltaY *= offset);
        return new GeoCoordinatesImpl(lon, lat);
    }

    public static GeoCoordinates scaleUpperRightCoordinate(GeoCoordinates lowerLeft, GeoCoordinates upperRight, double xfactor, double yfactor) throws InvalidMapDataException {
        return GeometryUtils.scaleUpperRightCoordinate(lowerLeft.getLongitudeDeg(), lowerLeft.getLatitudeDeg(), upperRight.getLongitudeDeg(), upperRight.getLatitudeDeg(), xfactor, yfactor);
    }

    public static GeoCoordinates scaleUpperRightCoordinate(double lowerLeftLon, double lowerLeftLat, double upperRightLon, double upperRightLat, double xfactor, double yfactor) throws InvalidMapDataException {
        assert (xfactor > 0.0 && yfactor > 0.0);
        GeoCoordinates newBottomRight = GeometryUtils.pointAlongLine(lowerLeftLon, lowerLeftLat, upperRightLon, lowerLeftLat, xfactor);
        GeoCoordinates newTopLeft = GeometryUtils.pointAlongLine(lowerLeftLon, lowerLeftLat, lowerLeftLon, upperRightLat, yfactor);
        return new GeoCoordinatesImpl(newBottomRight.getLongitudeDeg(), newTopLeft.getLatitudeDeg());
    }

    public static double round(double val) {
        return GeometryUtils.round(val, 5);
    }

    public static double round(double val, int decimalPlaces) {
        return (double)Math.round(val * Math.pow(10.0, decimalPlaces)) / Math.pow(10.0, decimalPlaces);
    }

    public static GeoCoordinates determineCoordinateInDistance(GeoCoordinates coord, int angle, double distanceKm) throws InvalidMapDataException {
        return GeometryUtils.determineCoordinateInDistance(coord.getLongitudeDeg(), coord.getLatitudeDeg(), angle, distanceKm);
    }

    public static GeoCoordinates determineCoordinateInDistance(double lon, double lat, int angle, double distanceKm) throws InvalidMapDataException {
        double lat2;
        double lat1 = lat * Math.PI / 180.0;
        double az12 = (double)angle * Math.PI / 180.0;
        double sinu1 = Math.sin(lat1);
        double cosu1 = Math.cos(lat1);
        double az12cos = Math.cos(az12);
        double az12sin = Math.sin(az12);
        double sina = cosu1 * az12sin;
        double ss = Math.sin(distanceKm / 6378.137);
        double cs = Math.cos(distanceKm / 6378.137);
        double g = sinu1 * ss - cosu1 * cs * az12cos;
        double lon2 = lon + Math.atan(ss * az12sin / (cosu1 * cs - sinu1 * ss * az12cos)) * 180.0 / Math.PI + 720.0;
        for (lat2 = Math.atan((sinu1 * cs + cosu1 * ss * az12cos) / Math.sqrt(sina * sina + g * g)) * 180.0 / Math.PI; lat2 > 90.0; lat2 -= 360.0) {
        }
        while (lon2 > 180.0) {
            lon2 -= 360.0;
        }
        return new GeoCoordinatesImpl(lon2, lat2);
    }

    public static enum BearingDirection {
        IN_DIRECTION,
        AGAINST_DIRECTION;

    }
}

