/*
 * Decompiled with CFR 0.152.
 */
package openlr.map.utils;

import java.util.ArrayList;
import java.util.Iterator;
import openlr.map.Line;
import openlr.map.Node;

public final class NodeCheck {
    private static final int DEGREE_2 = 2;
    private static final int DEGREE_4 = 4;

    private NodeCheck() {
        throw new UnsupportedOperationException();
    }

    public static boolean isValidNode(Node n) {
        if (n == null) {
            return false;
        }
        int degree = n.getNumberConnectedLines();
        if (degree == 2) {
            Iterator<Line> iter = n.getConnectedLines();
            Line line1 = iter.next();
            Line line2 = iter.next();
            return NodeCheck.isPair(line1, line2);
        }
        if (degree == 4) {
            Iterator<Line> connectedLines = n.getConnectedLines();
            ArrayList<Line> lines = new ArrayList<Line>();
            while (connectedLines.hasNext()) {
                lines.add(connectedLines.next());
            }
            Line line = (Line)lines.get(0);
            boolean found = false;
            for (int pos = 1; !found && pos < lines.size(); ++pos) {
                if (!NodeCheck.isPair(line, (Line)lines.get(pos))) continue;
                found = true;
                lines.remove(pos);
                lines.remove(0);
            }
            if (!found) {
                return true;
            }
            return !NodeCheck.isPair((Line)lines.get(0), (Line)lines.get(1));
        }
        return true;
    }

    public static boolean isPair(Line line1, Line line2) {
        return ((Object)line1.getStartNode()).equals(line2.getEndNode()) && ((Object)line1.getEndNode()).equals(line2.getStartNode());
    }
}

