/*
 * Decompiled with CFR 0.152.
 */
package openlr.map.utils;

import java.io.Serializable;
import java.util.Comparator;
import openlr.map.Line;
import openlr.map.utils.LineLinkedListElement;

public class PQElem
implements LineLinkedListElement {
    private static final int PRIME_NUMBER = 31;
    private final Line line;
    private final PQElem parent;
    private final int firstVal;
    private final int secondVal;

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PQElem)) {
            return false;
        }
        PQElem other = (PQElem)o;
        return this.line.getID() == other.line.getID();
    }

    public final int hashCode() {
        int hash = ((Object)this.line).hashCode();
        hash += 31 * (this.firstVal + this.secondVal);
        if (this.parent != null) {
            hash += ((Object)this.parent.getLine()).hashCode();
        }
        return hash;
    }

    public PQElem(Line l, int f, int s, PQElem p) {
        if (l == null) {
            throw new NullPointerException();
        }
        this.line = l;
        this.secondVal = s;
        this.firstVal = f;
        this.parent = p;
    }

    @Override
    public final Line getLine() {
        return this.line;
    }

    @Override
    public final PQElem getPrevious() {
        return this.parent;
    }

    public final int getFirstVal() {
        return this.firstVal;
    }

    public final int getSecondVal() {
        return this.secondVal;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("line: ").append(this.line.getID());
        sb.append(" first: ").append(this.firstVal);
        sb.append(" second: ").append(this.secondVal);
        sb.append(" parent: ").append(this.parent);
        return sb.toString();
    }

    public static class PQElemComparator
    implements Comparator<PQElem>,
    Serializable {
        private static final long serialVersionUID = 8164069785443434930L;

        @Override
        public final int compare(PQElem o1, PQElem o2) {
            int retval = 0;
            if (o1.firstVal < o2.firstVal) {
                retval = -1;
            } else if (o1.firstVal == o2.firstVal && o1.secondVal < o2.secondVal) {
                retval = -1;
            } else if (o1.firstVal > o2.firstVal) {
                retval = 1;
            } else if (o1.firstVal == o2.firstVal && o1.secondVal > o2.secondVal) {
                retval = 1;
            }
            return retval;
        }
    }
}

