/*
 * Decompiled with CFR 0.152.
 */
package openlr.map.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import openlr.map.Line;
import openlr.map.utils.LineLinkedListElement;

public final class PathUtils {
    private PathUtils() {
        throw new UnsupportedOperationException();
    }

    public static int getLength(List<Line> path, Line start, Line end) {
        if (path == null || path.isEmpty()) {
            return 0;
        }
        int posStart = path.indexOf(start);
        int posEnd = path.indexOf(end);
        if (posStart < 0 || posEnd < 0 || posEnd < posStart) {
            return -1;
        }
        int length = 0;
        for (int i = posStart; i <= posEnd; ++i) {
            length += path.get(i).getLineLength();
        }
        return length;
    }

    public static int getLength(List<Line> path) {
        if (path == null || path.isEmpty()) {
            return 0;
        }
        return PathUtils.getLength(path, path.get(0), path.get(path.size() - 1));
    }

    public static boolean checkPathConnection(List<Line> path) {
        if (path == null) {
            return true;
        }
        int size = path.size();
        for (int i = 0; i < size - 1; ++i) {
            Line currentline = path.get(i);
            Line successorline = path.get(i + 1);
            Iterator<Line> iter = currentline.getNextLines();
            boolean found = false;
            while (iter.hasNext()) {
                if (successorline.getID() != iter.next().getID()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static List<Line> constructPath(LineLinkedListElement dest) {
        ArrayList<Line> path = new ArrayList<Line>();
        if (dest != null) {
            path.add(dest.getLine());
            LineLinkedListElement akt = dest;
            while (akt.getPrevious() != null) {
                if (path.contains((akt = akt.getPrevious()).getLine())) {
                    return null;
                }
                path.add(0, akt.getLine());
            }
        }
        return path;
    }

    public static LineLinkedListElement findElementInQueue(Queue<? extends LineLinkedListElement> pq, Line line) {
        if (pq == null || line == null) {
            throw new IllegalArgumentException();
        }
        Iterator iter = pq.iterator();
        long id = line.getID();
        while (iter.hasNext()) {
            LineLinkedListElement next = (LineLinkedListElement)iter.next();
            if (next.getLine().getID() != id) continue;
            return next;
        }
        return null;
    }

    public static Line findCommonLineInPaths(List<? extends Line> location, LineLinkedListElement el) {
        Line line = null;
        LineLinkedListElement current = el;
        if (location != null && current != null && current.getLine() != null) {
            if (location.contains(current.getLine())) {
                line = current.getLine();
            } else {
                while (current.getPrevious() != null) {
                    if (!location.contains((current = current.getPrevious()).getLine())) continue;
                    line = current.getLine();
                    break;
                }
            }
        }
        return line;
    }
}

