package pl.qumak;

import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.support.SpringBootServletInitializer;
import pl.qumak.xml.Datex2Config;

@SpringBootApplication
public class Datex2TestApplication extends SpringBootServletInitializer {

    private static final Object[] CUSTOM_CONFIGS = {
            Datex2Config.class,
            Datex2TestApplication.class
    };

    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(CUSTOM_CONFIGS);
    }

    public static void main(String args[]) {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(CUSTOM_CONFIGS);
        builder.context();
        builder.run();

        Menu menu = new Menu();
        menu.run(builder);
    }
}

