package pl.qumak;

import org.springframework.boot.builder.SpringApplicationBuilder;
import pl.qumak.pull.PullService;
import pl.qumak.push.PushService;

import java.util.Scanner;

import static java.lang.System.exit;

class Menu {

    void run(SpringApplicationBuilder builder) {
        while (true) {
            clearScreen();
            System.out.println("==========================================================");
            System.out.println("Aplikacja do testów wysyłania/odbierania komunikatów");
            System.out.println("Jaką funkcję chcesz przetestować:");
            System.out.println("1) Odbieranie komunikatów przez interfejs komunikacyjny");
            System.out.println("2) Przesyłanie komunikatów przez interfejs komunikacyjny");
            System.out.println("==========================================================");
            System.out.println("Aby zakończyć wciśnij dowolny klawisz");
            Scanner sc = new Scanner(System.in);
            String sign = sc.nextLine();
            try {
                switch (Integer.parseInt(sign)) {
                    case 1:
                        PullService pullService = builder.context().getBean(PullService.class);
                        pullService.callWebService(builder);
                        break;
                    case 2:
                        PushService pushService = builder.context().getBean(PushService.class);
                        pushService.callWebService(builder);
                        break;
                    default:
                        exit(1);
                }
            } catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private static void clearScreen() {
        System.out.print("\033[H\033[2J");
        System.out.flush();
    }
}
