package pl.qumak.push;

import openlr.location.data.Orientation;

public class DirectionConverter {

    public static SituationDirectionType convert(Orientation orientation) {
        switch (orientation) {
            case BOTH:
                return SituationDirectionType.BOTH;
            case WITH_LINE_DIRECTION:
                return SituationDirectionType.WITH_LINE_DIRECTION;
            case AGAINST_LINE_DIRECTION:
                return SituationDirectionType.AGAINST_LINE_DIRECTION;
            default:
                return SituationDirectionType.NO_ORIENTATION_OR_UNKNOWN;
        }
    }

    public static Orientation convert(SituationDirectionType directionType) {
        switch (directionType) {
            case BOTH:
                return Orientation.BOTH.BOTH;
            case WITH_LINE_DIRECTION:
                return Orientation.WITH_LINE_DIRECTION;
            case AGAINST_LINE_DIRECTION:
                return Orientation.AGAINST_LINE_DIRECTION;
            default:
                return Orientation.NO_ORIENTATION_OR_UNKNOWN;
        }
    }
}
