package pl.qumak.push;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;


@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SituationDirectionType {
    WITH_LINE_DIRECTION("zgodnie z kierunkiem odcinka", "9FECD52C-84CC-48D3-827F-4A920DD7850E"),
    AGAINST_LINE_DIRECTION("przeciwnie do kierunku odcinka", "9708C0E8-BC13-4721-B3C9-6F1450B8C724"),
    BOTH("w obu kierunkach", "9CC39220-9646-4E7C-9B3D-0E3BE140FEAD"),
    NO_ORIENTATION_OR_UNKNOWN("brak lub nieznany", "13892CAE-A1C7-4B2F-A050-2709DAD89BB5");

    private String label;
    private String id;

    SituationDirectionType(String label, String id) {
        this.label = label;
        this.id = id;
    }

    @JsonProperty("name")
    public String getLabel() {
        return label;
    }

    public String getId() {
        return id;
    }



}