package pl.qumak.push;

import pl.qumak.xsd.datex2v3.MultilingualString;
import pl.qumak.xsd.datex2v3.MultilingualStringValue;
import pl.qumak.xsd.datex2v3.ObjectFactory;

import java.util.List;

public class StringHelper {

    private final ObjectFactory factory;
    private final String defaultLang;

    public StringHelper(ObjectFactory factory, String defaultLang) {
        this.factory = factory;
        this.defaultLang = defaultLang;
    }

    public MultilingualString createFrom(String value) {
        return createFrom(value, defaultLang);
    }

    public MultilingualString createFrom(String value, String lang) {
        final MultilingualString mls = factory.createMultilingualString();
        final MultilingualString.Values vals = factory.createMultilingualStringValues();
        final MultilingualStringValue val = factory.createMultilingualStringValue();
        val.setLang(lang);
        val.setValue(value);
        vals.getValue().add(val);
        mls.setValues(vals);
        return mls;
    }

    public static List<MultilingualStringValue> getFrom(MultilingualString value) {
        return value.getValues().getValue();
    }

    public static String getFirstFrom(MultilingualString value) {
        // not enough value
        return getFrom(value).get(0).getValue();
    }

}
